/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.ComponentsValidator;
import org.openapi4j.parser.validation.v3.ExternalDocsValidator;
import org.openapi4j.parser.validation.v3.InfoValidator;
import org.openapi4j.parser.validation.v3.PathValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SecurityRequirementValidator;
import org.openapi4j.parser.validation.v3.ServerValidator;
import org.openapi4j.parser.validation.v3.TagValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class OpenApiValidator
extends Validator3Base<OpenApi3, OpenApi3> {
    private static final String MISSING_REF_IN_PATH = "Missing $ref '%s' for parameter in path '%s'";
    private static final String REQUIRED_PATH_PARAM = "Parameter '%s' in path '%s' must have 'required' property set to true";
    private static final String UNEXPECTED_PATH_PARAM = "Path parameter '%s' in path '%s' is unexpected";
    private static final String MISMATCH_PATH_PARAM = "Path parameter '%s' in path '%s' is expected but undefined";
    private static final Pattern PATTERN_PATH_PARAM = Pattern.compile("/\\{(\\w+)\\}");
    private static final Pattern PATTERN_OAI3 = Pattern.compile("3\\.\\d+(\\.\\d+.*)?");
    private static final Validator<OpenApi3, OpenApi3> INSTANCE = new OpenApiValidator();

    private OpenApiValidator() {
    }

    public static Validator<OpenApi3, OpenApi3> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 root, OpenApi3 api, ValidationResults results) {
        this.validateString(api.getOpenapi(), results, true, PATTERN_OAI3, "openapi");
        this.validateField(api, api.getInfo(), results, true, "info", InfoValidator.instance());
        this.validateList(api, api.getServers(), results, false, "servers", ServerValidator.instance());
        this.validateMap(api, api.getPaths(), results, true, "paths", Regexes.PATH_REGEX, PathValidator.instance());
        this.validateField(api, api.getComponents(), results, false, "components", ComponentsValidator.instance());
        this.validateField(api, api.getSecurity(), results, false, "security", SecurityRequirementValidator.instance());
        this.validateList(api, api.getTags(), results, false, "tags", TagValidator.instance());
        this.validateField(api, api.getExternalDocs(), results, false, "externalDocs", ExternalDocsValidator.instance());
        this.validateMap(api, api.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        this.checkOperationsParams(api, api.getPaths(), results);
    }

    private void checkOperationsParams(OpenApi3 api, Map<String, Path> paths, ValidationResults results) {
        if (paths == null) {
            return;
        }
        for (Map.Entry<String, Path> pathEntry : paths.entrySet()) {
            String path = pathEntry.getKey();
            List<String> pathParams = this.getPathParams(path);
            for (Operation operation : pathEntry.getValue().getOperations().values()) {
                this.discoverAndCheckParams(api, path, pathParams, operation.getParameters(), results);
            }
        }
    }

    private void discoverAndCheckParams(OpenApi3 api, String path, List<String> pathParams, Collection<Parameter> parameters, ValidationResults results) {
        ArrayList<String> discoveredPathParameters = new ArrayList<String>();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramName = this.checkPathParam(api, path, pathParams, parameter, results);
                if (paramName == null) continue;
                discoveredPathParameters.add(paramName);
            }
        }
        this.validatePathParametersMatching(path, pathParams, discoveredPathParameters, results);
    }

    private String checkPathParam(OpenApi3 api, String path, List<String> pathParams, Parameter parameter, ValidationResults results) {
        String name;
        Boolean required;
        String in;
        if (parameter.isRef()) {
            Reference reference = api.getContext().getReferenceRegistry().getRef(parameter.getRef());
            if (reference == null) {
                results.addError(String.format(MISSING_REF_IN_PATH, parameter.getRef(), path), "$ref");
                return null;
            }
            in = reference.getContent().path("in").textValue();
            required = reference.getContent().path("required").booleanValue();
            name = reference.getContent().path("name").textValue();
        } else {
            in = parameter.getIn();
            required = parameter.getRequired();
            name = parameter.getName();
        }
        return this.checkPathParam(path, in, required, name, pathParams, results);
    }

    private String checkPathParam(String path, String in, Boolean required, String name, List<String> pathParams, ValidationResults results) {
        if (!"path".equals(in)) {
            return null;
        }
        if (!Boolean.TRUE.equals(required)) {
            results.addError(String.format(REQUIRED_PATH_PARAM, name, path), "required");
        }
        if (name == null) {
            return null;
        }
        if (!pathParams.contains(name)) {
            results.addError(String.format(UNEXPECTED_PATH_PARAM, name, path), "name");
        }
        return name;
    }

    private List<String> getPathParams(String path) {
        Matcher matcher = PATTERN_PATH_PARAM.matcher(path);
        ArrayList<String> pathParams = new ArrayList<String>();
        while (matcher.find()) {
            pathParams.add(matcher.group(1));
        }
        return pathParams;
    }

    private void validatePathParametersMatching(String path, List<String> refParams, List<String> discoveredParams, ValidationResults results) {
        for (String name : refParams) {
            if (discoveredParams.contains(name)) continue;
            results.addError(String.format(MISMATCH_PATH_PARAM, name, path), "name");
        }
    }
}

