/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.MediaTypeValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SchemaValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ParameterValidator
extends Validator3Base<OpenApi3, Parameter> {
    private static final String ALLOWED_RESERVED_IGNORED = "AllowReserved is ignored for non-query parameter '%s'";
    private static final String STYLE_ONLY_IN = "Style '%s' is only allowed in %s";
    private static final String STYLE_ONLY_IN_AND = "Style '%s' is only allowed in %s and %s";
    private static final String CONTENT_ONY_ONE_ERR_MSG = "content can only contain one media type.";
    private static final String CONTENT_SCHEMA_EXCLUSIVE_ERR_MSG = "Content and schema are mutually exclusive.";
    private static final Validator<OpenApi3, Parameter> INSTANCE = new ParameterValidator();

    private ParameterValidator() {
    }

    public static Validator<OpenApi3, Parameter> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Parameter parameter, ValidationResults results) {
        if (parameter.isRef()) {
            this.validateReference(api, parameter.getRef(), results, "$ref", ParameterValidator.instance(), Parameter.class);
        } else {
            this.validateString(parameter.getName(), results, true, "name");
            this.validateString(parameter.getIn(), results, true, Regexes.PARAM_IN_REGEX, "in");
            this.validateString(parameter.getStyle(), results, false, Regexes.STYLE_REGEX, "style");
            this.checkStyleValues(parameter, results);
            this.checkAllowReserved(parameter, results);
            this.validateField(api, parameter.getSchema(), results, false, "schema", SchemaValidator.instance());
            this.validateMap(api, parameter.getContentMediaTypes(), results, false, "content", Regexes.NOEXT_REGEX, MediaTypeValidator.instance());
            this.validateMap(api, parameter.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
            if (parameter.getContentMediaTypes() != null && parameter.getSchema() != null) {
                results.addError(CONTENT_SCHEMA_EXCLUSIVE_ERR_MSG);
            }
            if (parameter.getContentMediaTypes() != null && parameter.getContentMediaTypes().size() > 1) {
                results.addError(CONTENT_ONY_ONE_ERR_MSG);
            }
        }
    }

    private void checkAllowReserved(Parameter parameter, ValidationResults results) {
        if (parameter.isAllowReserved() && !"query".equals(parameter.getIn())) {
            results.addWarning(String.format(ALLOWED_RESERVED_IGNORED, parameter.getName()), "allowReserved");
        }
    }

    private void checkStyleValues(Parameter parameter, ValidationResults results) {
        String style = parameter.getStyle();
        if (style == null) {
            return;
        }
        String in = parameter.getIn();
        switch (style) {
            case "matrix": 
            case "label": {
                if ("path".equals(in)) break;
                results.addError(String.format(STYLE_ONLY_IN, style, "path"), "style");
                break;
            }
            case "form": {
                if ("query".equals(in) || "cookie".equals(in)) break;
                results.addError(String.format(STYLE_ONLY_IN_AND, style, "query", "cookie"), "style");
                break;
            }
            case "simple": {
                if ("path".equals(in) || "header".equals(in)) break;
                results.addError(String.format(STYLE_ONLY_IN_AND, style, "path", "header"), "style");
                break;
            }
            case "spaceDelimited": 
            case "pipeDelimited": 
            case "deepObject": {
                if ("query".equals(in)) break;
                results.addError(String.format(STYLE_ONLY_IN, style, "query"), "style");
                break;
            }
        }
    }
}

