/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.HeaderValidator;
import org.openapi4j.parser.validation.v3.LinkValidator;
import org.openapi4j.parser.validation.v3.MediaTypeValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ResponseValidator
extends Validator3Base<OpenApi3, Response> {
    private static final Validator<OpenApi3, Response> INSTANCE = new ResponseValidator();

    private ResponseValidator() {
    }

    public static Validator<OpenApi3, Response> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Response response, ValidationResults results) {
        if (response.isRef()) {
            this.validateReference(api, response.getRef(), results, "$ref", ResponseValidator.instance(), Response.class);
        } else {
            this.validateRequired(response.getDescription(), results, true, "description");
            this.validateMap(api, response.getHeaders(), results, false, "headers", null, HeaderValidator.instance());
            this.validateMap(api, response.getContentMediaTypes(), results, false, "content", Regexes.NOEXT_REGEX, MediaTypeValidator.instance());
            this.validateMap(api, response.getLinks(), results, false, "links", Regexes.NOEXT_NAME_REGEX, LinkValidator.instance());
            this.validateMap(api, response.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        }
    }
}

