/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Discriminator;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.DiscriminatorValidator;
import org.openapi4j.parser.validation.v3.ExternalDocsValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;
import org.openapi4j.parser.validation.v3.XmlValidator;

class SchemaValidator
extends Validator3Base<OpenApi3, Schema> {
    private static final Pattern TYPE_REGEX = Pattern.compile(String.join((CharSequence)"|", "boolean", "object", "array", "number", "integer", "string"));
    private static final String DISCRIM_ONLY_ONE = "The discriminator mapping '%s' MUST have only one of the composite keywords 'oneOf, anyOf, allOf'";
    private static final String DISCRIM_CONSTRAINT_MISSING = "The discriminator '%s' is not required or not a property of the allOf schemas";
    private static final String DISCRIM_REF_MAPPING = "Unable to map reference '%s' to schema content";
    private static final String DISCRIM_PROP_MISSING = "The discriminator '%s' is not a property of this schema";
    private static final String DISCRIM_REQUIRED_MISSING = "The discriminator '%s' is required in this schema";
    private static final String READ_WRITE_ONLY_EXCLUSIVE = "Schema cannot be both ReadOnly and WriteOnly";
    private static final Validator<OpenApi3, Schema> INSTANCE = new SchemaValidator();

    private SchemaValidator() {
    }

    public static Validator<OpenApi3, Schema> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Schema schema, ValidationResults results) {
        if (schema.isRef()) {
            this.validateReference(api, schema.getRef(), results, "$ref", SchemaValidator.instance(), Schema.class);
        } else {
            this.validateField(api, schema.getAdditionalProperties(), results, false, "additionalProperties", SchemaValidator.instance());
            this.validateField(api, schema.getDiscriminator(), results, false, "discriminator", DiscriminatorValidator.instance());
            this.checkDiscriminator(api, schema, results);
            this.validateType(schema.getDefault(), schema.getType(), results, "default");
            this.validateList(api, schema.getEnums(), results, false, "enum", null);
            this.validateMap(api, schema.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
            this.validateField(api, schema.getExternalDocs(), results, false, "externalDocs", ExternalDocsValidator.instance());
            this.validateFormat(schema.getFormat(), schema.getType(), results, "format");
            if (schema.getItemsSchema() != null) {
                this.validate(api, schema.getItemsSchema(), results);
            }
            this.validateNonNegative(schema.getMaxItems(), results, false, "maxItems");
            this.validateNonNegative(schema.getMinItems(), results, false, "minItems");
            this.validateNonNegative(schema.getMaxLength(), results, false, "maxLength");
            this.validateNonNegative(schema.getMinLength(), results, false, "minLength");
            this.validateNonNegative(schema.getMaxProperties(), results, false, "maxProperties");
            this.validateNonNegative(schema.getMinProperties(), results, false, "minProperties");
            this.validatePositive(schema.getMultipleOf(), results, false, "multipleOf");
            if (schema.getNotSchema() != null) {
                this.validate(api, schema.getNotSchema(), results);
            }
            this.validatePattern(schema.getPattern(), results, false, "pattern");
            this.validateMap(api, schema.getProperties(), results, false, "properties", null, this);
            this.validateList(api, schema.getRequiredFields(), results, false, "required", null);
            this.validateList(api, schema.getAllOfSchemas(), results, false, "allOf", this);
            this.validateList(api, schema.getAnyOfSchemas(), results, false, "anyOf", this);
            this.validateList(api, schema.getOneOfSchemas(), results, false, "oneOf", this);
            this.checkReadWrite(schema, results);
            this.validateString(schema.getType(), results, false, TYPE_REGEX, "type");
            this.validateField(api, schema.getXml(), results, false, "xml", XmlValidator.instance());
        }
    }

    private void checkDiscriminator(OpenApi3 api, Schema schema, ValidationResults results) {
        Discriminator discriminator = schema.getDiscriminator();
        if (discriminator == null) {
            return;
        }
        int count = 0;
        count += schema.hasAllOfSchemas() ? 1 : 0;
        count += schema.hasAnyOfSchemas() ? 1 : 0;
        if ((count += schema.hasOneOfSchemas() ? 1 : 0) > 1) {
            results.addError(String.format(DISCRIM_ONLY_ONE, discriminator.getPropertyName()), "discriminator");
        } else if (count == 0) {
            this.checkSchemaDiscriminator(api, discriminator, Collections.singletonList(schema), results);
        } else {
            this.checkSchemaCollections(api, schema, discriminator, results);
        }
    }

    private void checkSchemaCollections(OpenApi3 api, Schema schema, Discriminator discriminator, ValidationResults results) {
        if (schema.hasAllOfSchemas()) {
            if (!this.checkSchemaDiscriminator(api, discriminator, schema.getAllOfSchemas(), new ValidationResults())) {
                results.addError(String.format(DISCRIM_CONSTRAINT_MISSING, discriminator.getPropertyName()), "discriminator");
            }
        } else if (schema.hasAnyOfSchemas()) {
            this.checkSchemaDiscriminator(api, discriminator, schema.getAnyOfSchemas(), results);
        } else {
            this.checkSchemaDiscriminator(api, discriminator, schema.getOneOfSchemas(), results);
        }
    }

    private boolean checkSchemaDiscriminator(OpenApi3 api, Discriminator discriminator, List<Schema> schemas, ValidationResults results) {
        boolean hasProperty = true;
        for (Schema schema : schemas) {
            if (schema.isRef() && (schema = this.getReferenceContent(api, schema, results)) == null) continue;
            if (!schema.hasProperty(discriminator.getPropertyName())) {
                results.addError(String.format(DISCRIM_PROP_MISSING, discriminator.getPropertyName()), "discriminator");
                hasProperty = false;
            }
            if (schema.hasRequiredFields() && schema.getRequiredFields().contains(discriminator.getPropertyName())) continue;
            results.addError(String.format(DISCRIM_REQUIRED_MISSING, discriminator.getPropertyName()), "discriminator");
            hasProperty = false;
        }
        return hasProperty;
    }

    private Schema getReferenceContent(OpenApi3 api, Schema schema, ValidationResults results) {
        Reference reference = api.getContext().getReferenceRegistry().getRef(schema.getRef());
        if (reference == null) {
            results.addError(String.format(DISCRIM_REF_MAPPING, schema.getRef()), "discriminator");
            return null;
        }
        try {
            return (Schema)reference.getMappedContent(Schema.class);
        }
        catch (DecodeException e) {
            results.addError(String.format(DISCRIM_REF_MAPPING, schema.getRef()), "discriminator");
            return null;
        }
    }

    private void checkReadWrite(Schema schema, ValidationResults results) {
        if (schema.isReadOnly() && schema.isWriteOnly()) {
            results.addError(READ_WRITE_ONLY_EXCLUSIVE);
        }
    }
}

