/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Server;
import org.openapi4j.parser.model.v3.ServerVariable;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.ServerVariableValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ServerValidator
extends Validator3Base<OpenApi3, Server> {
    private static final String VARIABLE_NOT_DEFINED = "Undefined variable '%s' for url '%s'";
    private static final String VARIABLES_NOT_DEFINED = "Undefined variables for url '%s'";
    private static final Pattern PATTERN_VARIABLES = Pattern.compile("(\\{)(.*?)(\\})");
    private static final Validator<OpenApi3, Server> INSTANCE = new ServerValidator();

    private ServerValidator() {
    }

    public static Validator<OpenApi3, Server> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Server server, ValidationResults results) {
        this.checkUrlWithVariables(server, results);
        this.validateMap(api, server.getVariables(), results, false, "variables", Regexes.NAME_REGEX, ServerVariableValidator.instance());
        this.validateMap(api, server.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
    }

    private void checkUrlWithVariables(Server server, ValidationResults results) {
        String url = server.getUrl();
        Matcher matcher = PATTERN_VARIABLES.matcher(url);
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            variables.add(matcher.group(2));
        }
        if (variables.isEmpty()) {
            this.validateUrl(url, results, true, "url", ValidationSeverity.ERROR);
        } else if (server.getVariables() != null && server.getVariables().size() != 0) {
            for (String variable : variables) {
                ServerVariable definedVar = server.getVariables().get(variable);
                if (definedVar != null && definedVar.getDefault() != null) {
                    url = url.replace("{" + variable + "}", definedVar.getDefault());
                    continue;
                }
                results.addError(String.format(VARIABLE_NOT_DEFINED, variable, url), "url");
            }
            this.validateUrl(url, results, true, "url", ValidationSeverity.ERROR);
        } else {
            results.addError(String.format(VARIABLES_NOT_DEFINED, url), "url");
        }
    }
}

