/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Collection;
import java.util.Map;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.ValidatorBase;
import org.openapi4j.parser.validation.v3.Regexes;

abstract class Validator3Base<O extends OpenApi3, T>
extends ValidatorBase<O, T> {
    private static final String FORMAT_TYPE_MISMATCH = "Format '%s' is incompatible with schema type '%s'";
    private static final String VALUE_TYPE_MISMATCH = "Value '%s' is incompatible with schema type '%s'";
    private static final String REF_MISSING = "Missing $ref '%s'";
    private static final String REF_CONTENT_UNREADABLE = "Unable to read $ref content at '%s'.";
    private static final String EMAIL_INVALID = "Invalid email address '%s'";

    Validator3Base() {
    }

    void validateFormat(String format, String type, ValidationResults results, String crumb) {
        if (format != null && type != null) {
            String expectedType;
            switch (format) {
                case "int32": 
                case "int64": {
                    expectedType = "integer";
                    break;
                }
                case "float": 
                case "double": {
                    expectedType = "number";
                    break;
                }
                default: {
                    expectedType = "string";
                }
            }
            if (!type.equals(expectedType)) {
                results.addError(String.format(FORMAT_TYPE_MISMATCH, format, type), crumb);
            }
        }
    }

    void validateType(Object defaultValue, String type, ValidationResults results, String crumb) {
        if (defaultValue != null && type != null) {
            boolean ok;
            switch (type) {
                case "string": {
                    ok = defaultValue instanceof String;
                    break;
                }
                case "number": {
                    ok = defaultValue instanceof Number;
                    break;
                }
                case "integer": {
                    ok = defaultValue instanceof Integer;
                    break;
                }
                case "boolean": {
                    ok = defaultValue instanceof Boolean;
                    break;
                }
                case "object": {
                    ok = defaultValue instanceof Map;
                    break;
                }
                default: {
                    ok = defaultValue instanceof Collection;
                }
            }
            if (!ok) {
                results.addError(String.format(VALUE_TYPE_MISMATCH, defaultValue, type), crumb);
            }
        }
    }

    <F> void validateReference(OpenApi3 api, String $ref, ValidationResults results, String crumb, Validator<OpenApi3, F> validator, Class<F> clazz) {
        Reference reference = api.getContext().getReferenceRegistry().getRef($ref);
        if (reference == null || reference.getContent().isMissingNode()) {
            results.addError(String.format(REF_MISSING, $ref), crumb);
        } else {
            try {
                Object value = reference.getMappedContent(clazz);
                validator.validate(api, value, results);
            }
            catch (DecodeException e) {
                results.addError(String.format(REF_CONTENT_UNREADABLE, $ref), crumb);
            }
        }
    }

    @Override
    protected void checkEmail(String email, ValidationResults results, String crumb) {
        if (!Regexes.EMAIL_REGEX.matcher(email).matches()) {
            results.addError(String.format(EMAIL_INVALID, email), crumb);
        }
    }
}

