/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.Server;

public class Link
extends AbsExtendedRefOpenApiSchema<Link> {
    private String operationId;
    private String operationRef;
    private Map<String, String> parameters;
    private Map<String, Header> headers;
    private String description;
    private Server server;

    public String getOperationId() {
        return this.operationId;
    }

    public Link setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public String getOperationRef() {
        return this.operationRef;
    }

    public Link setOperationRef(String operationRef) {
        this.operationRef = operationRef;
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Link setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean hasParameter(String name) {
        return this.mapHas(this.parameters, name);
    }

    public String getParameter(String name) {
        return this.mapGet(this.parameters, name);
    }

    public Link setParameter(String name, String parameter) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(name, parameter);
        return this;
    }

    public Link removeParameter(String name) {
        this.mapRemove(this.parameters, name);
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public Link setHeaders(Map<String, Header> headers) {
        this.headers = headers;
        return this;
    }

    public boolean hasHeader(String name) {
        return this.mapHas(this.headers, name);
    }

    public Header getHeader(String name) {
        return this.mapGet(this.headers, name);
    }

    public Link setHeader(String name, Header header) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Header>();
        }
        this.headers.put(name, header);
        return this;
    }

    public Link removeHeader(String name) {
        this.mapRemove(this.headers, name);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Link setDescription(String description) {
        this.description = description;
        return this;
    }

    public Server getServer() {
        return this.server;
    }

    public Link setServer(Server server) {
        this.server = server;
        return this;
    }

    @Override
    protected Link copyReference(OAIContext context) {
        Link copy = new Link();
        copy.setRef(this.getRef());
        return copy;
    }

    @Override
    protected Link copyContent(OAIContext context, boolean followRefs) {
        Link copy = new Link();
        copy.setOperationId(this.getOperationId());
        copy.setOperationRef(this.getOperationRef());
        copy.setParameters(this.copyMap(this.getParameters()));
        copy.setHeaders(this.copyMap(this.getHeaders(), context, followRefs));
        copy.setDescription(this.getDescription());
        copy.setServer(this.copyField(this.getServer(), context, followRefs));
        copy.setExtensions(this.copyMap(this.getExtensions()));
        return copy;
    }
}

