/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.Server;

public class Path
extends AbsExtendedOpenApiSchema<Path> {
    private String description;
    @JsonAlias(value={"get", "put", "post", "delete", "options", "head", "patch", "trace"})
    @JsonIgnore
    private Map<String, Operation> operations = new HashMap<String, Operation>();
    private List<Parameter> parameters;
    private List<Server> servers;
    private String summary;

    public Operation getGet() {
        return this.operations.get("get");
    }

    public Path setGet(Operation get) {
        this.operations.put("get", get);
        return this;
    }

    public Operation getPut() {
        return this.operations.get("put");
    }

    public Path setPut(Operation put) {
        this.operations.put("put", put);
        return this;
    }

    public Operation getPost() {
        return this.operations.get("post");
    }

    public Path setPost(Operation post) {
        this.operations.put("post", post);
        return this;
    }

    public Operation getDelete() {
        return this.operations.get("delete");
    }

    public Path setDelete(Operation delete) {
        this.operations.put("delete", delete);
        return this;
    }

    public Operation getOptions() {
        return this.operations.get("options");
    }

    public Path setOptions(Operation options) {
        this.operations.put("options", options);
        return this;
    }

    public Operation getHead() {
        return this.operations.get("head");
    }

    public Path setHead(Operation head) {
        this.operations.put("head", head);
        return this;
    }

    public Operation getPatch() {
        return this.operations.get("patch");
    }

    public Path setPatch(Operation patch) {
        this.operations.put("patch", patch);
        return this;
    }

    public Operation getTrace() {
        return this.operations.get("trace");
    }

    public Path setTrace(Operation trace) {
        this.operations.put("trace", trace);
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Path setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Path setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Operation> getOperations() {
        return this.operations;
    }

    public Path setOperations(Map<String, Operation> operations) {
        this.operations = operations;
        return this;
    }

    public boolean hasOperation(String id) {
        return this.mapHas(this.operations, id);
    }

    public Operation getOperation(String id) {
        return this.mapGet(this.operations, id);
    }

    public Path setOperation(String id, Operation operation) {
        if (this.operations == null) {
            this.operations = new HashMap<String, Operation>();
        }
        this.operations.put(id, operation);
        return this;
    }

    public Path removeOperation(String id) {
        this.mapRemove(this.operations, id);
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public Path setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public boolean hasServers() {
        return this.servers != null;
    }

    public Path addServer(Server server) {
        this.servers = this.listAdd(this.servers, server);
        return this;
    }

    public Path insertServer(int index, Server server) {
        this.servers = this.listAdd(this.servers, index, server);
        return this;
    }

    public Path removeServer(Server value) {
        this.listRemove(this.servers, value);
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Path setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean hasParameters() {
        return this.parameters != null;
    }

    public Path addParameter(Parameter parameter) {
        this.parameters = this.listAdd(this.parameters, parameter);
        return this;
    }

    public Path insertParameter(int index, Parameter parameter) {
        this.parameters = this.listAdd(this.parameters, index, parameter);
        return this;
    }

    public Path removeParameter(Parameter value) {
        this.listRemove(this.parameters, value);
        return this;
    }

    @Override
    public Path copy(OAIContext context, boolean followRefs) {
        Path copy = new Path();
        copy.setSummary(this.getSummary());
        copy.setDescription(this.getDescription());
        copy.setOperations(this.copyMap(this.getOperations(), context, followRefs));
        copy.setServers(this.copyList(this.getServers(), context, followRefs));
        copy.setParameters(this.copyList(this.getParameters(), context, followRefs));
        copy.setExtensions(this.copyMap(this.getExtensions()));
        return copy;
    }
}

