/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3.bind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openapi4j.parser.model.v3.Discriminator;
import org.openapi4j.parser.model.v3.ExternalDocs;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.model.v3.Xml;

public class SchemaDeserializer
extends StdDeserializer<Schema> {
    protected SchemaDeserializer() {
        this(Schema.class);
    }

    protected SchemaDeserializer(Class<Schema> vc) {
        super(vc);
    }

    public Schema deserialize(JsonParser jp, DeserializationContext context) throws IOException {
        Schema schema = new Schema();
        block76: while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            JsonToken token = jp.nextToken();
            switch (name) {
                case "title": {
                    schema.setTitle(jp.getText());
                    continue block76;
                }
                case "multipleOf": {
                    schema.setMultipleOf(jp.getNumberValue());
                    continue block76;
                }
                case "maximum": {
                    schema.setMaximum(jp.getNumberValue());
                    continue block76;
                }
                case "exclusiveMaximum": {
                    schema.setExclusiveMaximum(jp.getBooleanValue());
                    continue block76;
                }
                case "minimum": {
                    schema.setMinimum(jp.getNumberValue());
                    continue block76;
                }
                case "exclusiveMinimum": {
                    schema.setExclusiveMinimum(jp.getBooleanValue());
                    continue block76;
                }
                case "maxLength": {
                    schema.setMaxLength(jp.getIntValue());
                    continue block76;
                }
                case "minLength": {
                    schema.setMinLength(jp.getIntValue());
                    continue block76;
                }
                case "pattern": {
                    schema.setPattern(jp.getText());
                    continue block76;
                }
                case "maxItems": {
                    schema.setMaxItems(jp.getIntValue());
                    continue block76;
                }
                case "minItems": {
                    schema.setMinItems(jp.getIntValue());
                    continue block76;
                }
                case "uniqueItems": {
                    schema.setUniqueItems(jp.getBooleanValue());
                    continue block76;
                }
                case "maxProperties": {
                    schema.setMaxProperties(jp.getIntValue());
                    continue block76;
                }
                case "minProperties": {
                    schema.setMinProperties(jp.getIntValue());
                    continue block76;
                }
                case "required": {
                    schema.setRequiredFields((List)jp.readValueAs((TypeReference)new TypeReference<List<String>>(){}));
                    continue block76;
                }
                case "enum": {
                    schema.setEnums((List)jp.readValueAs((TypeReference)new TypeReference<List<String>>(){}));
                    continue block76;
                }
                case "type": {
                    schema.setType(jp.getText());
                    continue block76;
                }
                case "allOf": {
                    schema.setAllOfSchemas((List)jp.readValueAs((TypeReference)new TypeReference<List<Schema>>(){}));
                    continue block76;
                }
                case "oneOf": {
                    schema.setOneOfSchemas((List)jp.readValueAs((TypeReference)new TypeReference<List<Schema>>(){}));
                    continue block76;
                }
                case "anyOf": {
                    schema.setAnyOfSchemas((List)jp.readValueAs((TypeReference)new TypeReference<List<Schema>>(){}));
                    continue block76;
                }
                case "not": {
                    schema.setNotSchema((Schema)jp.readValueAs((TypeReference)new TypeReference<Schema>(){}));
                    continue block76;
                }
                case "items": {
                    schema.setItemsSchema((Schema)jp.readValueAs((TypeReference)new TypeReference<Schema>(){}));
                    continue block76;
                }
                case "properties": {
                    schema.setProperties((Map)jp.readValueAs((TypeReference)new TypeReference<Map<String, Schema>>(){}));
                    continue block76;
                }
                case "additionalProperties": {
                    if (token.isBoolean()) {
                        schema.setAdditionalPropertiesAllowed(jp.getBooleanValue());
                        continue block76;
                    }
                    if (token.isStructStart()) {
                        schema.setAdditionalProperties((Schema)jp.readValueAs((TypeReference)new TypeReference<Schema>(){}));
                        continue block76;
                    }
                    throw new IOException("Unexpected value type");
                }
                case "description": {
                    schema.setDescription(jp.getText());
                    continue block76;
                }
                case "format": {
                    schema.setFormat(jp.getText());
                    continue block76;
                }
                case "default": {
                    schema.setDefault(jp.readValueAs((TypeReference)new TypeReference<Object>(){}));
                    continue block76;
                }
                case "nullable": {
                    schema.setNullable(jp.getBooleanValue());
                    continue block76;
                }
                case "discriminator": {
                    schema.setDiscriminator((Discriminator)jp.readValueAs((TypeReference)new TypeReference<Discriminator>(){}));
                    continue block76;
                }
                case "readOnly": {
                    schema.setReadOnly(jp.getBooleanValue());
                    continue block76;
                }
                case "writeOnly": {
                    schema.setWriteOnly(jp.getBooleanValue());
                    continue block76;
                }
                case "xml": {
                    schema.setXml((Xml)jp.readValueAs((TypeReference)new TypeReference<Xml>(){}));
                    continue block76;
                }
                case "externalDocs": {
                    schema.setExternalDocs((ExternalDocs)jp.readValueAs((TypeReference)new TypeReference<ExternalDocs>(){}));
                    continue block76;
                }
                case "example": {
                    schema.setExample(jp.readValueAs((TypeReference)new TypeReference<Object>(){}));
                    continue block76;
                }
                case "deprecated": {
                    schema.setDeprecated(jp.getBooleanValue());
                    continue block76;
                }
                case "$ref": {
                    schema.setRef(jp.getValueAsString());
                    continue block76;
                }
            }
            schema.setExtension(name, jp.readValueAs((TypeReference)new TypeReference<Object>(){}));
        }
        return schema;
    }
}

