/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openapi4j.core.model.OAI;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.validation.Validator;

public abstract class ValidatorBase<O extends OAI, T>
implements Validator<O, T> {
    private static final String MALFORMED_SPEC = "Malformed spec around '%s'";
    private static final String DUPLICATED_VALUES = "Duplicated values in '%s'";
    private static final String INVALID_PATTERN = "Pattern '%s' is not valid";
    private static final String POSITIVE_STRICT_VALUE = "Value '%s' must be strictly positive";
    private static final String POSITIVE_VALUE = "Value '%s' must be positive or 0";
    private static final String MISSING_REQUIRED_FIELD = "Required field is missing '%s'";
    private static final String PATTERN_NOT_MATCHED = "String value '%s' does not match required pattern '%s'";
    private static final String INVALID_KEY = "Invalid key '%s' in map '%s'";
    private static final String INVALID_URL = "Invalid URL '%s'";

    protected <F> void validate(O api, F value, ValidationResults results, String crumb, Validator<O, F> validator) {
        if (validator != null) {
            if (value == null) {
                results.addError(String.format(MALFORMED_SPEC, crumb));
            } else {
                validator.validate(api, value, results);
            }
        }
    }

    protected <F> void validateField(O api, F value, ValidationResults results, boolean required, String crumb, Validator<O, F> validator) {
        results.withCrumb(crumb, () -> {
            if (this.validateRequired(value, results, required, crumb)) {
                this.validate(api, value, results, crumb, validator);
            }
        });
    }

    protected <V> void validateList(O api, Collection<? extends V> value, ValidationResults results, boolean required, String crumb, Validator<O, V> validator) {
        results.withCrumb(crumb, () -> {
            if (this.validateRequired(value, results, required, crumb)) {
                HashSet set = new HashSet(value);
                if (set.size() != value.size()) {
                    results.addError(String.format(DUPLICATED_VALUES, crumb), crumb);
                }
                if (validator != null) {
                    for (Object element : value) {
                        this.validate(api, element, results, crumb, validator);
                    }
                }
            }
        });
    }

    protected void validatePattern(String pattern, ValidationResults results, boolean required, String crumb) {
        if (this.validateRequired(pattern, results, required, crumb)) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                results.addError(String.format(INVALID_PATTERN, pattern), crumb);
            }
        }
    }

    protected <N extends Number> void validatePositive(N value, ValidationResults results, boolean required, String crumb) {
        if (this.validateRequired(value, results, required, crumb) && value.intValue() <= 0) {
            results.addError(String.format(POSITIVE_STRICT_VALUE, value), crumb);
        }
    }

    protected <N extends Number> void validateNonNegative(N value, ValidationResults results, boolean required, String crumb) {
        if (this.validateRequired(value, results, required, crumb) && value.intValue() < 0) {
            results.addError(String.format(POSITIVE_VALUE, value), crumb);
        }
    }

    protected boolean validateRequired(Object value, ValidationResults results, boolean required, String crumb) {
        boolean isPresent;
        boolean bl = isPresent = value != null;
        if (required && !isPresent) {
            results.addError(String.format(MISSING_REQUIRED_FIELD, crumb));
            return false;
        }
        return isPresent;
    }

    protected void validateString(String value, ValidationResults results, boolean required, String crumb) {
        this.validateString(value, results, required, (Pattern)null, crumb);
    }

    protected void validateString(String value, ValidationResults results, boolean required, String pattern, String crumb) {
        this.validateString(value, results, required, Pattern.compile(pattern), crumb);
    }

    protected void validateString(String value, ValidationResults results, boolean required, Pattern pattern, String crumb) {
        if (this.validateRequired(value, results, required, crumb) && pattern != null && !pattern.matcher(value).matches()) {
            results.addError(String.format(PATTERN_NOT_MATCHED, value, pattern), crumb);
        }
    }

    protected void validateUrl(String value, ValidationResults results, boolean required, String crumb, ValidationSeverity severity) {
        this.validateString(value, results, required, (Pattern)null, crumb);
        if (value != null) {
            this.checkUrl(value, results, crumb, severity);
        }
    }

    protected void validateEmail(String value, ValidationResults results, boolean required, String crumb) {
        this.validateString(value, results, required, (Pattern)null, crumb);
        if (value != null) {
            this.checkEmail(value, results, crumb);
        }
    }

    protected abstract void checkEmail(String var1, ValidationResults var2, String var3);

    protected <V> void validateMap(O api, Map<String, ? extends V> value, ValidationResults results, boolean required, String crumb, Pattern pattern, Validator<O, V> validator) {
        results.withCrumb(crumb, () -> {
            if (this.validateRequired(value, results, required, crumb)) {
                for (Map.Entry entry : value.entrySet()) {
                    results.withCrumb((String)entry.getKey(), () -> {
                        this.checkKey((String)entry.getKey(), pattern, results);
                        this.validate(api, entry.getValue(), results, crumb, validator);
                    });
                }
            }
        });
    }

    private void checkKey(String key, Pattern pattern, ValidationResults results) {
        if (pattern != null && !pattern.matcher(key).matches()) {
            results.addError(String.format(INVALID_KEY, key, pattern));
        }
    }

    private void checkUrl(String urlSpec, ValidationResults results, String crumb, ValidationSeverity severity) {
        try {
            new URL(urlSpec);
        }
        catch (MalformedURLException e) {
            results.add(severity, String.format(INVALID_URL, urlSpec), crumb);
        }
    }
}

