/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Callback;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.v3.ExpressionValidator;
import org.openapi4j.parser.validation.v3.PathValidator;
import org.openapi4j.parser.validation.v3.Regexes;

class CallbackValidator
extends ExpressionValidator<Callback> {
    private static final CallbackValidator INSTANCE = new CallbackValidator();

    private CallbackValidator() {
    }

    public static CallbackValidator instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Callback callback, ValidationResults results) {
        if (callback.isRef()) {
            this.validateReference(api, callback.getRef(), results, "$ref", CallbackValidator.instance(), Callback.class);
        } else {
            this.validateMap(api, callback.getCallbackPaths(), results, false, null, Regexes.NOEXT_REGEX, PathValidator.instance());
            this.validateMap(api, callback.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        }
    }
}

