/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.MediaTypeValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.SchemaValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class HeaderValidator
extends Validator3Base<OpenApi3, Header> {
    private static final String CONTENT_ONY_ONE_ERR_MSG = "Content can only contain one media type.";
    private static final String CONTENT_SCHEMA_EXCLUSIVE_ERR_MSG = "Content and schema are mutually exclusive.";
    private static final Validator<OpenApi3, Header> INSTANCE = new HeaderValidator();

    private HeaderValidator() {
    }

    public static Validator<OpenApi3, Header> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Header header, ValidationResults results) {
        if (header.isRef()) {
            this.validateReference(api, header.getRef(), results, "$ref", HeaderValidator.instance(), Header.class);
        } else {
            this.validateString(header.getStyle(), results, false, "simple", "style");
            this.validateField(api, header.getSchema(), results, false, "schema", SchemaValidator.instance());
            this.validateMap(api, header.getContentMediaTypes(), results, false, "content", Regexes.NOEXT_REGEX, MediaTypeValidator.instance());
            this.validateMap(api, header.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
            if (header.getContentMediaTypes() != null && header.getSchema() != null) {
                results.addError(CONTENT_SCHEMA_EXCLUSIVE_ERR_MSG);
            }
            if (header.getContentMediaTypes() != null && header.getContentMediaTypes().size() > 1) {
                results.addError(CONTENT_ONY_ONE_ERR_MSG);
            }
        }
    }
}

