/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Link;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.validation.v3.ExpressionValidator;
import org.openapi4j.parser.validation.v3.HeaderValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.ServerValidator;

class LinkValidator
extends ExpressionValidator<Link> {
    private static final String OP_FIELD_MISSING_ERR_MSG = "'operationRef', 'operationId' or '$ref' field missing.";
    private static final String OP_FIELD_EXCLUSIVE_ERR_MSG = "'operationRef' and 'operationId' fields are mutually exclusives.";
    private static final String OP_NOT_FOUND_ERR_MSG = "'%s' not found.";
    private static final String PARAM_NOT_FOUND_ERR_MSG = "Parameter name '%s' not found in target operation.";
    private static final LinkValidator INSTANCE = new LinkValidator();

    private LinkValidator() {
    }

    public static LinkValidator instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Link link, ValidationResults results) {
        if (link.isRef()) {
            this.validateReference(api, link.getRef(), results, "links", LinkValidator.instance(), Link.class);
        } else {
            this.validateMap(api, link.getHeaders(), results, false, "headers", Regexes.NOEXT_REGEX, HeaderValidator.instance());
            this.validateMap(api, link.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
            this.validateField(api, link.getServer(), results, false, "server", ServerValidator.instance());
        }
    }

    void validateWithOperation(OpenApi3 api, Operation srcOperation, Link link, ValidationResults results) {
        if (link.isRef()) {
            link = this.getReferenceContent(api, link.getRef(), results, "links", Link.class);
        }
        String operationRef = link.getOperationRef();
        String operationId = link.getOperationId();
        Operation targetOperation = null;
        if (operationId != null && operationRef != null) {
            results.addError(OP_FIELD_EXCLUSIVE_ERR_MSG);
        } else if (operationRef != null) {
            targetOperation = this.getReferenceContent(api, operationRef, results, "operationRef", Operation.class);
        } else if (operationId != null) {
            targetOperation = this.findOperationById(api, operationId, results);
        } else {
            results.addError(OP_FIELD_MISSING_ERR_MSG);
        }
        if (targetOperation != null) {
            if (link.getParameters() == null) {
                return;
            }
            for (String expression : link.getParameters().values()) {
                this.validateExpression(api, srcOperation, expression, results);
            }
            this.checkTargetOperationParameters(targetOperation, link, results);
        }
    }

    private Operation findOperationById(OpenApi3 api, String operationId, ValidationResults results) {
        Operation operation = api.getOperationById(operationId);
        if (operation == null) {
            results.addError(String.format(OP_NOT_FOUND_ERR_MSG, operationId), "operationRef");
        }
        return operation;
    }

    private void checkTargetOperationParameters(Operation operation, Link link, ValidationResults results) {
        for (String paramName : link.getParameters().keySet()) {
            boolean hasParameter = false;
            if (operation.hasParameters()) {
                for (Parameter param : operation.getParameters()) {
                    if (!paramName.equals(param.getName())) continue;
                    hasParameter = true;
                    break;
                }
            }
            if (hasParameter) continue;
            results.addError(String.format(PARAM_NOT_FOUND_ERR_MSG, paramName));
        }
    }
}

