/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Map;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Callback;
import org.openapi4j.parser.model.v3.Link;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.CallbackValidator;
import org.openapi4j.parser.validation.v3.ExternalDocsValidator;
import org.openapi4j.parser.validation.v3.LinkValidator;
import org.openapi4j.parser.validation.v3.ParameterValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.RequestBodyValidator;
import org.openapi4j.parser.validation.v3.ResponseValidator;
import org.openapi4j.parser.validation.v3.SecurityRequirementValidator;
import org.openapi4j.parser.validation.v3.ServerValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class OperationValidator
extends Validator3Base<OpenApi3, Operation> {
    private static final Validator<OpenApi3, Operation> INSTANCE = new OperationValidator();

    private OperationValidator() {
    }

    public static Validator<OpenApi3, Operation> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Operation operation, ValidationResults results) {
        this.validateField(api, operation.getExternalDocs(), results, false, "externalDocs", ExternalDocsValidator.instance());
        this.validateString(operation.getOperationId(), results, false, "operationId");
        this.validateList(api, operation.getParameters(), results, false, "parameters", ParameterValidator.instance());
        this.validateField(api, operation.getRequestBody(), results, false, "requestBody", RequestBodyValidator.instance());
        this.validateMap(api, operation.getResponses(), results, true, "responses", Regexes.RESPONSE_REGEX, ResponseValidator.instance());
        this.validateMap(api, operation.getCallbacks(), results, false, "callbacks", Regexes.NOEXT_REGEX, CallbackValidator.instance());
        this.validateList(api, operation.getSecurityRequirements(), results, false, "security", SecurityRequirementValidator.instance());
        this.validateList(api, operation.getServers(), results, false, "servers", ServerValidator.instance());
        this.validateMap(api, operation.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        this.validateCallbacks(api, operation, results);
        this.validateResponseLinks(api, operation, results);
    }

    private void validateCallbacks(OpenApi3 api, Operation operation, ValidationResults results) {
        if (operation.getCallbacks() == null) {
            return;
        }
        for (Callback callback : operation.getCallbacks().values()) {
            if (callback.isRef()) {
                callback = this.getReferenceContent(api, callback.getRef(), results, "callbacks", Callback.class);
            }
            if (callback.getCallbackPaths() == null) continue;
            for (String path : callback.getCallbackPaths().keySet()) {
                CallbackValidator.instance().validateExpression(api, operation, path, results);
            }
        }
    }

    private void validateResponseLinks(OpenApi3 api, Operation operation, ValidationResults results) {
        if (operation.getResponses() == null) {
            return;
        }
        for (Response response : operation.getResponses().values()) {
            if (response.getLinks() == null) continue;
            for (Map.Entry<String, Link> entry : response.getLinks().entrySet()) {
                results.withCrumb("links." + entry.getKey(), () -> LinkValidator.instance().validateWithOperation(api, operation, (Link)entry.getValue(), results));
            }
        }
    }
}

