/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.ValidatorBase;
import org.openapi4j.parser.validation.v3.Regexes;

abstract class Validator3Base<O extends OpenApi3, T>
extends ValidatorBase<O, T> {
    private static final String REF_MISSING = "Missing $ref '%s'";
    private static final String REF_CONTENT_UNREADABLE = "Unable to read $ref content for '%s' pointer.";
    private static final String EMAIL_INVALID = "Invalid email address '%s'";

    Validator3Base() {
    }

    <F> F getReferenceContent(OpenApi3 api, String $ref, ValidationResults results, String crumb, Class<F> clazz) {
        Reference reference = api.getContext().getReferenceRegistry().getRef($ref);
        if (reference == null || reference.getContent().isMissingNode()) {
            results.addError(String.format(REF_MISSING, $ref), crumb);
        } else {
            try {
                return (F)reference.getMappedContent(clazz);
            }
            catch (DecodeException e) {
                results.addError(String.format(REF_CONTENT_UNREADABLE, $ref), crumb);
            }
        }
        return null;
    }

    <F> void validateReference(OpenApi3 api, String $ref, ValidationResults results, String crumb, Validator<OpenApi3, F> validator, Class<F> clazz) {
        F content = this.getReferenceContent(api, $ref, results, crumb, clazz);
        if (content != null) {
            validator.validate(api, content, results);
        }
    }

    @Override
    protected void checkEmail(String email, ValidationResults results, String crumb) {
        if (!Regexes.EMAIL_REGEX.matcher(email).matches()) {
            results.addError(String.format(EMAIL_INVALID, email), crumb);
        }
    }
}

