/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.Contact;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ContactValidator
extends Validator3Base<OpenApi3, Contact> {
    private static final Validator<OpenApi3, Contact> INSTANCE = new ContactValidator();

    private ContactValidator() {
    }

    public static Validator<OpenApi3, Contact> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, Contact contact, ValidationResults results) {
        this.validateString(contact.getEmail(), results, false, EMAIL_REGEX, "email");
        this.validateMap(api, contact.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        this.validateString(contact.getName(), results, false, "name");
        this.validateUrl(contact.getUrl(), results, false, false, "url", ValidationSeverity.ERROR);
    }
}

