/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OAuthFlow;
import org.openapi4j.parser.model.v3.OAuthFlows;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.SecurityScheme;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.OAuthFlowValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class SecuritySchemeValidator
extends Validator3Base<OpenApi3, SecurityScheme> {
    private static final Pattern TYPE_REGEX = Pattern.compile(String.join((CharSequence)"|", "apiKey", "http", "oauth2", "openIdConnect"));
    private static final Pattern IN_REGEX = Pattern.compile(String.join((CharSequence)"|", "query", "header", "cookie"));
    private static final String OAUTH_FLOW_REQUIRED = "At least one OAuth flow is required";
    private static final Validator<OpenApi3, SecurityScheme> INSTANCE = new SecuritySchemeValidator();

    private SecuritySchemeValidator() {
    }

    public static Validator<OpenApi3, SecurityScheme> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, SecurityScheme securityScheme, ValidationResults results) {
        if (securityScheme.isRef()) {
            this.validateReference(api, securityScheme, results, "$ref", SecuritySchemeValidator.instance(), SecurityScheme.class);
        } else {
            this.validateString(securityScheme.getType(), results, true, TYPE_REGEX, "type");
            if (securityScheme.getType() != null) {
                String s = securityScheme.getType();
                if ("http".equals(s)) {
                    this.validateString(securityScheme.getScheme(), results, true, "scheme");
                } else if ("apiKey".equals(s)) {
                    this.validateString(securityScheme.getName(), results, true, "name");
                    this.validateString(securityScheme.getIn(), results, true, IN_REGEX, "in");
                } else if ("oauth2".equals(s)) {
                    OAuthFlows flows = securityScheme.getFlows();
                    Validator<OpenApi3, OAuthFlow> flowValidator = OAuthFlowValidator.instance();
                    this.validateField(api, flows.getAuthorizationCode(), results, false, "authorizationCode", flowValidator);
                    this.validateField(api, flows.getClientCredentials(), results, false, "clientCredentials", flowValidator);
                    this.validateField(api, flows.getImplicit(), results, false, "implicit", flowValidator);
                    this.validateField(api, flows.getPassword(), results, false, "password", flowValidator);
                    this.validateMap(api, flows.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
                    if (flows.getAuthorizationCode() == null && flows.getClientCredentials() == null && flows.getImplicit() == null && flows.getPassword() == null) {
                        results.addError(OAUTH_FLOW_REQUIRED, "flows");
                    }
                } else if ("openIdConnect".equals(s)) {
                    this.validateUrl(securityScheme.getOpenIdConnectUrl(), results, true, false, "openIdConnectUrl", ValidationSeverity.ERROR);
                }
            }
            this.validateMap(api, securityScheme.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        }
    }
}

