/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.v3.AbsExtendedRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Discriminator;
import org.openapi4j.parser.model.v3.ExternalDocs;
import org.openapi4j.parser.model.v3.Xml;

public class Schema
extends AbsExtendedRefOpenApiSchema<Schema> {
    @JsonIgnore
    private Schema additionalProperties;
    @JsonIgnore
    private Boolean additionalPropertiesAllowed;
    @JsonProperty(value="default")
    private Object defaultValue;
    private String description;
    private Boolean deprecated;
    private Discriminator discriminator;
    @JsonProperty(value="enum")
    private List<Object> enums;
    private Object example;
    private Boolean exclusiveMaximum;
    private Boolean exclusiveMinimum;
    private ExternalDocs externalDocs;
    private String format;
    @JsonProperty(value="items")
    private Schema itemsSchema;
    private Number maximum;
    private Number minimum;
    private Integer maxItems;
    private Integer minItems;
    private Integer maxLength;
    private Integer minLength;
    private Integer maxProperties;
    private Integer minProperties;
    private Number multipleOf;
    @JsonProperty(value="not")
    private Schema notSchema;
    private Boolean nullable;
    private String pattern;
    private Map<String, Schema> properties;
    @JsonProperty(value="required")
    private List<String> requiredFields;
    @JsonProperty(value="allOf")
    private List<Schema> allOfSchemas;
    @JsonProperty(value="anyOf")
    private List<Schema> anyOfSchemas;
    @JsonProperty(value="oneOf")
    private List<Schema> oneOfSchemas;
    private Boolean readOnly;
    private Boolean writeOnly;
    private String type;
    private String title;
    private Boolean uniqueItems;
    private Xml xml;

    public String getTitle() {
        return this.title;
    }

    public Schema setTitle(String title) {
        this.title = title;
        return this;
    }

    public Number getMultipleOf() {
        return this.multipleOf;
    }

    public Schema setMultipleOf(Number multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public Schema setMaximum(Number maximum) {
        this.maximum = maximum;
        return this;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public boolean isExclusiveMaximum() {
        return Boolean.TRUE.equals(this.exclusiveMaximum);
    }

    public Schema setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public Schema setMinimum(Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public boolean isExclusiveMinimum() {
        return Boolean.TRUE.equals(this.exclusiveMinimum);
    }

    public Schema setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Schema setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Schema setMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Schema setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public Schema setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public Schema setMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.uniqueItems);
    }

    public Schema setUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public Schema setMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public Schema setMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public List<String> getRequiredFields() {
        return this.requiredFields;
    }

    public Schema setRequiredFields(List<String> requiredFields) {
        this.requiredFields = requiredFields;
        return this;
    }

    public boolean hasRequiredFields() {
        return this.requiredFields != null;
    }

    public Schema addRequiredField(String requiredField) {
        this.requiredFields = this.listAdd(this.requiredFields, requiredField);
        return this;
    }

    public Schema insertRequiredField(int index, String value) {
        this.requiredFields = this.listAdd(this.requiredFields, index, value);
        return this;
    }

    public Schema removeRequiredField(String value) {
        this.listRemove(this.requiredFields, value);
        return this;
    }

    public List<Object> getEnums() {
        return this.enums;
    }

    public Schema setEnums(List<Object> enums) {
        this.enums = enums;
        return this;
    }

    public boolean hasEnums() {
        return this.enums != null;
    }

    public Schema addEnum(Object value) {
        this.enums = this.listAdd(this.enums, value);
        return this;
    }

    public Schema insertEnum(int index, Object value) {
        this.enums = this.listAdd(this.enums, index, value);
        return this;
    }

    public Schema removeEnum(Object value) {
        this.listRemove(this.enums, value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public String getSupposedType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.getProperties() != null) {
            return "object";
        }
        if (this.getItemsSchema() != null) {
            return "array";
        }
        if (this.getFormat() != null) {
            switch (this.getFormat()) {
                case "int32": 
                case "int64": {
                    return "integer";
                }
                case "float": 
                case "double": {
                    return "number";
                }
            }
            return "string";
        }
        return null;
    }

    public Schema setType(String type) {
        this.type = type;
        return this;
    }

    public List<Schema> getAllOfSchemas() {
        return this.allOfSchemas;
    }

    public Schema setAllOfSchemas(List<Schema> value) {
        this.allOfSchemas = value;
        return this;
    }

    public boolean hasAllOfSchemas() {
        return this.allOfSchemas != null && !this.allOfSchemas.isEmpty();
    }

    public Schema addAllOfSchema(Schema value) {
        this.allOfSchemas = this.listAdd(this.allOfSchemas, value);
        return this;
    }

    public Schema insertAllOfSchema(int index, Schema value) {
        this.allOfSchemas = this.listAdd(this.allOfSchemas, index, value);
        return this;
    }

    public Schema removeAllOfSchema(Schema value) {
        this.listRemove(this.allOfSchemas, value);
        return this;
    }

    public List<Schema> getOneOfSchemas() {
        return this.oneOfSchemas;
    }

    public Schema setOneOfSchemas(List<Schema> oneOfSchemas) {
        this.oneOfSchemas = oneOfSchemas;
        return this;
    }

    public boolean hasOneOfSchemas() {
        return this.oneOfSchemas != null && !this.oneOfSchemas.isEmpty();
    }

    public Schema addOneOfSchema(Schema value) {
        this.oneOfSchemas = this.listAdd(this.oneOfSchemas, value);
        return this;
    }

    public Schema insertOneOfSchema(int index, Schema value) {
        this.oneOfSchemas = this.listAdd(this.oneOfSchemas, index, value);
        return this;
    }

    public Schema removeOneOfSchema(Schema value) {
        this.listRemove(this.oneOfSchemas, value);
        return this;
    }

    public List<Schema> getAnyOfSchemas() {
        return this.anyOfSchemas;
    }

    public Schema setAnyOfSchemas(List<Schema> anyOfSchemas) {
        this.anyOfSchemas = anyOfSchemas;
        return this;
    }

    public boolean hasAnyOfSchemas() {
        return this.anyOfSchemas != null && !this.anyOfSchemas.isEmpty();
    }

    public Schema addAnyOfSchema(Schema value) {
        this.anyOfSchemas = this.listAdd(this.anyOfSchemas, value);
        return this;
    }

    public Schema insertAnyOfSchema(int index, Schema anyOfSchema) {
        this.anyOfSchemas = this.listAdd(this.anyOfSchemas, index, anyOfSchema);
        return this;
    }

    public Schema removeAnyOfSchema(Schema value) {
        this.listRemove(this.anyOfSchemas, value);
        return this;
    }

    public Schema getNotSchema() {
        return this.notSchema;
    }

    public Schema setNotSchema(Schema notSchema) {
        this.notSchema = notSchema;
        return this;
    }

    public Schema getItemsSchema() {
        return this.itemsSchema;
    }

    public Schema setItemsSchema(Schema itemsSchema) {
        this.itemsSchema = itemsSchema;
        return this;
    }

    public Map<String, Schema> getProperties() {
        return this.properties;
    }

    public Schema setProperties(Map<String, Schema> properties) {
        this.properties = properties;
        return this;
    }

    public boolean hasProperty(String name) {
        return this.mapHas(this.properties, name);
    }

    public Schema getProperty(String name) {
        return this.mapGet(this.properties, name);
    }

    public Schema setProperty(String name, Schema property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Schema>();
        }
        this.properties.put(name, property);
        return this;
    }

    public Schema removeProperty(String name) {
        this.mapRemove(this.properties, name);
        return this;
    }

    public Schema getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Schema setAdditionalProperties(Schema additionalProperties) {
        this.additionalProperties = additionalProperties;
        this.additionalPropertiesAllowed = additionalProperties == null;
        return this;
    }

    @JsonProperty(value="additionalProperties", access=JsonProperty.Access.WRITE_ONLY)
    private void setMappedAdditionalProperties(JsonNode additionalProperties) throws JsonProcessingException {
        if (additionalProperties.isBoolean()) {
            this.setAdditionalPropertiesAllowed(additionalProperties.booleanValue());
        } else if (additionalProperties.isObject()) {
            this.setAdditionalProperties((Schema)TreeUtil.json.treeToValue((TreeNode)additionalProperties, Schema.class));
        }
    }

    @JsonProperty(value="additionalProperties", access=JsonProperty.Access.READ_ONLY)
    private Object getMappedAdditionalProperties() {
        if (this.hasAdditionalProperties()) {
            return this.getAdditionalProperties();
        }
        if (this.getAdditionalPropertiesAllowed() != null) {
            return this.getAdditionalPropertiesAllowed();
        }
        return null;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public Boolean getAdditionalPropertiesAllowed() {
        return this.additionalPropertiesAllowed;
    }

    public boolean isAdditionalPropertiesAllowed() {
        return this.additionalPropertiesAllowed == null || Boolean.TRUE.equals(this.additionalPropertiesAllowed);
    }

    public Schema setAdditionalPropertiesAllowed(Boolean additionalPropertiesAllowed) {
        this.additionalPropertiesAllowed = additionalPropertiesAllowed;
        this.additionalProperties = null;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Schema setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public Schema setFormat(String format) {
        this.format = format;
        return this;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Schema setDefault(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public boolean isNullable() {
        return Boolean.TRUE.equals(this.nullable);
    }

    public Schema setNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public Schema setDiscriminator(Discriminator discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean isReadOnly() {
        return Boolean.TRUE.equals(this.readOnly);
    }

    public Schema setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public boolean isWriteOnly() {
        return Boolean.TRUE.equals(this.writeOnly);
    }

    public Schema setWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public Xml getXml() {
        return this.xml;
    }

    public Schema setXml(Xml xml) {
        this.xml = xml;
        return this;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public Schema setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public Schema setExample(Object example) {
        this.example = example;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    public Schema setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    @Override
    protected Schema copyReference(OAIContext context) {
        Schema copy = new Schema();
        copy.setRef(this.getRef());
        copy.setCanonicalRef(this.getCanonicalRef());
        return copy;
    }

    @Override
    protected Schema copyContent(OAIContext context, boolean followRefs) {
        Schema copy = new Schema();
        copy.setTitle(this.getTitle());
        copy.setMultipleOf(this.getMultipleOf());
        copy.setMaximum(this.getMaximum());
        copy.setExclusiveMaximum(this.getExclusiveMaximum());
        copy.setMinimum(this.getMinimum());
        copy.setExclusiveMinimum(this.getExclusiveMinimum());
        copy.setMaxLength(this.getMaxLength());
        copy.setMinLength(this.getMinLength());
        copy.setPattern(this.getPattern());
        copy.setMaxItems(this.getMaxItems());
        copy.setMinItems(this.getMinItems());
        copy.setUniqueItems(this.getUniqueItems());
        copy.setMaxProperties(this.getMaxProperties());
        copy.setMinProperties(this.getMinProperties());
        copy.setRequiredFields(this.copyList(this.getRequiredFields()));
        copy.setEnums(this.copyList(this.getEnums()));
        copy.setType(this.getType());
        boolean followSchemaCollectionsRefs = followRefs && this.getDiscriminator() == null;
        copy.setAllOfSchemas(this.copyList(this.getAllOfSchemas(), context, followSchemaCollectionsRefs));
        copy.setOneOfSchemas(this.copyList(this.getOneOfSchemas(), context, followSchemaCollectionsRefs));
        copy.setAnyOfSchemas(this.copyList(this.getAnyOfSchemas(), context, followSchemaCollectionsRefs));
        copy.setNotSchema(this.copyField(this.getNotSchema(), context, followRefs));
        copy.setItemsSchema(this.copyField(this.getItemsSchema(), context, followRefs));
        copy.setProperties(this.copyMap(this.getProperties(), context, followRefs));
        if (this.hasAdditionalProperties()) {
            copy.setAdditionalProperties(this.copyField(this.getAdditionalProperties(), context, followRefs));
        } else if (this.getAdditionalPropertiesAllowed() != null) {
            copy.setAdditionalPropertiesAllowed(this.getAdditionalPropertiesAllowed());
        }
        copy.setDescription(this.getDescription());
        copy.setFormat(this.getFormat());
        copy.setDefault(this.getDefault());
        copy.setNullable(this.getNullable());
        copy.setDiscriminator(this.copyField(this.getDiscriminator(), context, followRefs));
        copy.setReadOnly(this.getReadOnly());
        copy.setWriteOnly(this.getWriteOnly());
        copy.setXml(this.copyField(this.getXml(), context, followRefs));
        copy.setExternalDocs(this.copyField(this.getExternalDocs(), context, followRefs));
        copy.setExample(this.getExample());
        copy.setDeprecated(this.getDeprecated());
        copy.setExtensions(this.copyMap(this.getExtensions()));
        return copy;
    }
}

