/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Info;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.ContactValidator;
import org.openapi4j.parser.validation.v3.LicenseValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class InfoValidator
extends Validator3Base<OpenApi3, Info> {
    private static final Validator<OpenApi3, Info> INSTANCE = new InfoValidator();

    private InfoValidator() {
    }

    public static Validator<OpenApi3, Info> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Info info, ValidationResults results) {
        this.validateField(context, api, info.getContact(), results, false, "contact", ContactValidator.instance());
        this.validateMap(context, api, info.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
        this.validateField(context, api, info.getLicense(), results, false, "license", LicenseValidator.instance());
        this.validateUrl(api, info.getTermsOfService(), results, false, true, "termsOfService");
        this.validateString(info.getTitle(), results, true, "title");
        this.validateString(info.getVersion(), results, true, "version");
    }
}

