/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.v3.AbsExtendedRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Example;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Schema;

public abstract class AbsParameter<M extends OpenApiSchema<M>>
extends AbsExtendedRefOpenApiSchema<M> {
    private Boolean allowReserved;
    @JsonProperty(value="content")
    private Map<String, MediaType> contentMediaTypes;
    private Boolean deprecated;
    private String description;
    private Object example;
    private Map<String, Example> examples;
    private Boolean explode;
    private Boolean required;
    private Schema schema;
    private String style;

    public String getDescription() {
        return this.description;
    }

    public AbsParameter<M> setDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public boolean isRequired() {
        return Boolean.TRUE.equals(this.required);
    }

    public AbsParameter<M> setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public boolean isDeprecated() {
        return Boolean.TRUE.equals(this.deprecated);
    }

    public AbsParameter<M> setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public String getStyle() {
        return this.style;
    }

    public AbsParameter<M> setStyle(String style) {
        this.style = style;
        return this;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public boolean isExplode() {
        return Boolean.TRUE.equals(this.explode);
    }

    public AbsParameter<M> setExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public Boolean getAllowReserved() {
        return this.allowReserved;
    }

    public boolean isAllowReserved() {
        return Boolean.TRUE.equals(this.allowReserved);
    }

    public AbsParameter<M> setAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public AbsParameter<M> setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public AbsParameter<M> setExample(Object example) {
        this.example = example;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public AbsParameter<M> setExamples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public boolean hasExample(String name) {
        return this.mapHas(this.examples, name);
    }

    public Example getExample(String name) {
        return this.mapGet(this.examples, name);
    }

    public AbsParameter<M> setExample(String name, Example example) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(name, example);
        return this;
    }

    public AbsParameter<M> removeExample(String name) {
        this.mapRemove(this.examples, name);
        return this;
    }

    public Map<String, MediaType> getContentMediaTypes() {
        return this.contentMediaTypes;
    }

    public AbsParameter<M> setContentMediaTypes(Map<String, MediaType> contentMediaTypes) {
        this.contentMediaTypes = contentMediaTypes;
        return this;
    }

    public boolean hasContentMediaType(String name) {
        return this.mapHas(this.contentMediaTypes, name);
    }

    public MediaType getContentMediaType(String name) {
        return this.mapGet(this.contentMediaTypes, name);
    }

    public AbsParameter<M> setContentMediaType(String name, MediaType contentMediaType) {
        if (this.contentMediaTypes == null) {
            this.contentMediaTypes = new HashMap<String, MediaType>();
        }
        this.contentMediaTypes.put(name, contentMediaType);
        return this;
    }

    public AbsParameter<M> removeContentMediaType(String name) {
        this.mapRemove(this.contentMediaTypes, name);
        return this;
    }

    void copy(AbsParameter<M> copy) {
        copy.setDescription(this.getDescription());
        copy.setRequired(this.getRequired());
        copy.setDeprecated(this.getDeprecated());
        copy.setStyle(this.getStyle());
        copy.setExplode(this.getExplode());
        copy.setAllowReserved(this.getAllowReserved());
        copy.setSchema(this.copyField(this.getSchema()));
        copy.setExample(this.getExample());
        copy.setExamples(this.copyMap(this.getExamples()));
        copy.setContentMediaTypes(this.getContentMediaTypes());
        copy.setExtensions(this.copySimpleMap(this.getExtensions()));
    }
}

