/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.parser.model.AbsRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Path;

public class Callback
extends AbsRefOpenApiSchema<Callback> {
    @JsonIgnore
    private Map<String, Path> callbackPaths;
    @JsonIgnore
    private Map<String, Object> extensions;

    public Map<String, Path> getCallbackPaths() {
        return this.callbackPaths;
    }

    public Callback setCallbackPaths(Map<String, Path> callbackPaths) {
        this.callbackPaths = callbackPaths;
        return this;
    }

    public boolean hasCallbackPath(String expression) {
        return this.mapHas(this.callbackPaths, expression);
    }

    public Path getCallbackPath(String expression) {
        return this.mapGet(this.callbackPaths, expression);
    }

    public Callback setCallbackPath(String expression, Path callbackPath) {
        if (this.callbackPaths == null) {
            this.callbackPaths = new HashMap<String, Path>();
        }
        this.callbackPaths.put(expression, callbackPath);
        return this;
    }

    public Callback removeCallbackPath(String expression) {
        this.mapRemove(this.callbackPaths, expression);
        return this;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        this.extensions = extensions;
    }

    public void setExtension(String name, Object value) {
        if (this.extensions == null) {
            this.extensions = new HashMap<String, Object>();
        }
        this.extensions.put(name, value);
    }

    @JsonAnyGetter
    private Map<String, Object> any() {
        if (this.callbackPaths != null && this.extensions != null) {
            this.extensions.putAll(this.callbackPaths);
            return this.extensions;
        }
        if (this.callbackPaths != null) {
            return new HashMap<String, Object>(this.callbackPaths);
        }
        return this.extensions;
    }

    @JsonAnySetter
    private void add(String name, Object value) {
        if (value == null) {
            return;
        }
        try {
            Path path = (Path)TreeUtil.json.convertValue(value, Path.class);
            this.setCallbackPath(name, path);
        }
        catch (IllegalArgumentException ex) {
            this.setExtension(name, value);
        }
    }

    @Override
    public Callback copy() {
        Callback copy = new Callback();
        if (this.isRef()) {
            copy.setRef(this.getRef());
            copy.setCanonicalRef(this.getCanonicalRef());
        } else {
            copy.setCallbackPaths(this.copyMap(this.getCallbackPaths()));
            copy.setExtensions(this.copySimpleMap(this.getExtensions()));
        }
        return copy;
    }
}

