/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import java.util.HashMap;
import java.util.Map;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;
import org.openapi4j.parser.model.v3.Callback;
import org.openapi4j.parser.model.v3.Example;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.Link;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.model.v3.RequestBody;
import org.openapi4j.parser.model.v3.Response;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.model.v3.SecurityScheme;

public class Components
extends AbsExtendedOpenApiSchema<Components> {
    private Map<String, Callback> callbacks;
    private Map<String, Example> examples;
    private Map<String, Header> headers;
    private Map<String, Link> links;
    private Map<String, Parameter> parameters;
    private Map<String, RequestBody> requestBodies;
    private Map<String, Response> responses;
    private Map<String, Schema> schemas;
    private Map<String, SecurityScheme> securitySchemes;

    public Map<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Components setSchemas(Map<String, Schema> schemas) {
        this.schemas = schemas;
        return this;
    }

    public boolean hasSchema(String name) {
        return this.mapHas(this.schemas, name);
    }

    public Schema getSchema(String name) {
        return this.mapGet(this.schemas, name);
    }

    public Components setSchema(String name, Schema schema) {
        if (this.schemas == null) {
            this.schemas = new HashMap<String, Schema>();
        }
        this.schemas.put(name, schema);
        return this;
    }

    public Components removeSchema(String name) {
        this.mapRemove(this.schemas, name);
        return this;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public Components setResponses(Map<String, Response> responses) {
        this.responses = responses;
        return this;
    }

    public boolean hasResponse(String name) {
        return this.mapHas(this.responses, name);
    }

    public Response getResponse(String name) {
        return this.mapGet(this.responses, name);
    }

    public Components setResponse(String name, Response response) {
        if (this.responses == null) {
            this.responses = new HashMap<String, Response>();
        }
        this.responses.put(name, response);
        return this;
    }

    public Components removeResponse(String name) {
        this.mapRemove(this.responses, name);
        return this;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Components setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public boolean hasParameter(String name) {
        return this.mapHas(this.parameters, name);
    }

    public Parameter getParameter(String name) {
        return this.mapGet(this.parameters, name);
    }

    public Components setParameter(String name, Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Parameter>();
        }
        this.parameters.put(name, parameter);
        return this;
    }

    public Components removeParameter(String name) {
        this.mapRemove(this.parameters, name);
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Components setExamples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public boolean hasExample(String name) {
        return this.mapHas(this.examples, name);
    }

    public Example getExample(String name) {
        return this.mapGet(this.examples, name);
    }

    public Components setExample(String name, Example example) {
        if (this.examples == null) {
            this.examples = new HashMap<String, Example>();
        }
        this.examples.put(name, example);
        return this;
    }

    public Components removeExample(String name) {
        this.mapRemove(this.examples, name);
        return this;
    }

    public Map<String, RequestBody> getRequestBodies() {
        return this.requestBodies;
    }

    public Components setRequestBodies(Map<String, RequestBody> requestBodies) {
        this.requestBodies = requestBodies;
        return this;
    }

    public boolean hasRequestBody(String name) {
        return this.mapHas(this.requestBodies, name);
    }

    public RequestBody getRequestBody(String name) {
        return this.mapGet(this.requestBodies, name);
    }

    public Components setRequestBody(String name, RequestBody requestBody) {
        if (this.requestBodies == null) {
            this.requestBodies = new HashMap<String, RequestBody>();
        }
        this.requestBodies.put(name, requestBody);
        return this;
    }

    public Components removeRequestBody(String name) {
        this.mapRemove(this.requestBodies, name);
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public Components setHeaders(Map<String, Header> headers) {
        this.headers = headers;
        return this;
    }

    public boolean hasHeader(String name) {
        return this.mapHas(this.headers, name);
    }

    public Header getHeader(String name) {
        return this.mapGet(this.headers, name);
    }

    public Components setHeader(String name, Header header) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Header>();
        }
        this.headers.put(name, header);
        return this;
    }

    public Components removeHeader(String name) {
        this.mapRemove(this.headers, name);
        return this;
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public Components setSecuritySchemes(Map<String, SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
        return this;
    }

    public boolean hasSecurityScheme(String name) {
        return this.mapHas(this.securitySchemes, name);
    }

    public SecurityScheme getSecurityScheme(String name) {
        return this.mapGet(this.securitySchemes, name);
    }

    public Components setSecurityScheme(String name, SecurityScheme securityScheme) {
        if (this.securitySchemes == null) {
            this.securitySchemes = new HashMap<String, SecurityScheme>();
        }
        this.securitySchemes.put(name, securityScheme);
        return this;
    }

    public Components removeSecurityScheme(String name) {
        this.mapRemove(this.securitySchemes, name);
        return this;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public Components setLinks(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public boolean hasLink(String name) {
        return this.mapHas(this.links, name);
    }

    public Link getLink(String name) {
        return this.mapGet(this.links, name);
    }

    public Components setLink(String name, Link link) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(name, link);
        return this;
    }

    public Components removeLink(String name) {
        this.mapRemove(this.links, name);
        return this;
    }

    public Map<String, Callback> getCallbacks() {
        return this.callbacks;
    }

    public Components setCallbacks(Map<String, Callback> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public boolean hasCallback(String name) {
        return this.mapHas(this.callbacks, name);
    }

    public Callback getCallback(String name) {
        return this.mapGet(this.callbacks, name);
    }

    public Components setCallback(String name, Callback callback) {
        if (this.callbacks == null) {
            this.callbacks = new HashMap<String, Callback>();
        }
        this.callbacks.put(name, callback);
        return this;
    }

    public Components removeCallback(String name) {
        this.mapRemove(this.callbacks, name);
        return this;
    }

    @Override
    public Components copy() {
        Components copy = new Components();
        copy.setSchemas(this.copyMap(this.getSchemas()));
        copy.setResponses(this.copyMap(this.getResponses()));
        copy.setParameters(this.copyMap(this.getParameters()));
        copy.setExamples(this.copyMap(this.getExamples()));
        copy.setRequestBodies(this.copyMap(this.getRequestBodies()));
        copy.setHeaders(this.copyMap(this.getHeaders()));
        copy.setSecuritySchemes(this.copyMap(this.getSecuritySchemes()));
        copy.setLinks(this.copyMap(this.getLinks()));
        copy.setCallbacks(this.copyMap(this.getCallbacks()));
        copy.setExtensions(this.copySimpleMap(this.getExtensions()));
        return copy;
    }
}

