/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.parser.model.v3.AbsExtendedOpenApiSchema;

public class OAuthFlow
extends AbsExtendedOpenApiSchema<OAuthFlow> {
    private String authorizationUrl;
    private String tokenUrl;
    private String refreshUrl;
    private Map<String, String> scopes;
    @JsonIgnore
    private String configuration;

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public OAuthFlow setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public OAuthFlow setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public OAuthFlow setRefreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public OAuthFlow setConfiguration(String configuration) {
        this.configuration = configuration;
        return this;
    }

    public Map<String, String> getScopes() {
        return this.scopes;
    }

    public OAuthFlow setScopes(Map<String, String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public boolean hasScope(String name) {
        return this.mapHas(this.scopes, name);
    }

    public String getScope(String name) {
        return this.mapGet(this.scopes, name);
    }

    public OAuthFlow setScope(String name, String scope) {
        if (this.scopes == null) {
            this.scopes = new HashMap<String, String>();
        }
        this.scopes.put(name, scope);
        return this;
    }

    public OAuthFlow removeScope(String name) {
        this.mapRemove(this.scopes, name);
        return this;
    }

    @Override
    public OAuthFlow copy() {
        OAuthFlow copy = new OAuthFlow();
        copy.setAuthorizationUrl(this.getAuthorizationUrl());
        copy.setTokenUrl(this.getTokenUrl());
        copy.setRefreshUrl(this.getRefreshUrl());
        copy.setScopes(this.copySimpleMap(this.getScopes()));
        copy.setConfiguration(this.getConfiguration());
        copy.setExtensions(this.copySimpleMap(this.getExtensions()));
        return copy;
    }
}

