/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.v3.Contact;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ContactValidator
extends Validator3Base<OpenApi3, Contact> {
    private static final Validator<OpenApi3, Contact> INSTANCE = new ContactValidator();

    private ContactValidator() {
    }

    public static Validator<OpenApi3, Contact> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Contact contact, ValidationResults results) {
        this.validateString(contact.getEmail(), results, false, EMAIL_REGEX, OAI3Keywords.CRUMB_EMAIL);
        this.validateMap(context, api, contact.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
        this.validateString(contact.getName(), results, false, OAI3Keywords.CRUMB_NAME);
        this.validateUrl(api, contact.getUrl(), results, false, true, OAI3Keywords.CRUMB_URL);
    }
}

