/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.Link;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Parameter;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.v3.ExpressionValidator;
import org.openapi4j.parser.validation.v3.HeaderValidator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.ServerValidator;

class LinkValidator
extends ExpressionValidator<Link> {
    private static final ValidationResult OP_FIELD_MISSING_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(115), "'operationRef', 'operationId' or '$ref' field missing.");
    private static final ValidationResult OP_FIELD_EXCLUSIVE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(116), "'operationRef' and 'operationId' fields are mutually exclusives.");
    private static final ValidationResult OP_NOT_FOUND_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(117), "'%s' not found.");
    private static final ValidationResult PARAM_NOT_FOUND_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(118), "Parameter name '%s' not found in target operation.");
    private static final LinkValidator INSTANCE = new LinkValidator();

    private LinkValidator() {
    }

    public static LinkValidator instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Link link, ValidationResults results) {
        if (link.isRef()) {
            this.validateReference(context, api, link, results, OAI3Keywords.CRUMB_LINKS, LinkValidator.instance(), Link.class);
        } else {
            this.validateMap(context, api, link.getHeaders(), results, false, OAI3Keywords.CRUMB_HEADERS, Regexes.NOEXT_REGEX, HeaderValidator.instance());
            this.validateMap(context, api, link.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
            this.validateField(context, api, link.getServer(), results, false, OAI3Keywords.CRUMB_SERVER, ServerValidator.instance());
        }
    }

    void validateWithOperation(OpenApi3 api, Operation srcOperation, Link link, ValidationResults results) {
        if (link.isRef()) {
            link = this.getReferenceContent(api, link, results, OAI3Keywords.CRUMB_LINKS, Link.class);
        }
        String operationRef = link.getOperationRef();
        String operationId = link.getOperationId();
        Operation targetOperation = null;
        if (operationId != null && operationRef != null) {
            results.add(OP_FIELD_EXCLUSIVE_ERR, new Object[0]);
        } else if (operationRef != null) {
            targetOperation = this.getOperationRefContent(api, operationRef, results);
        } else if (operationId != null) {
            targetOperation = this.findOperationById(api, operationId, results);
        } else {
            results.add(OP_FIELD_MISSING_ERR, new Object[0]);
        }
        if (targetOperation != null) {
            if (link.getParameters() == null) {
                return;
            }
            for (String expression : link.getParameters().values()) {
                this.validateExpression(api, srcOperation, expression, results);
            }
            this.checkTargetOperationParameters(targetOperation, link, results);
        }
    }

    private Operation findOperationById(OpenApi3 api, String operationId, ValidationResults results) {
        Operation operation = api.getOperationById(operationId);
        if (operation == null) {
            results.add(OAI3Keywords.CRUMB_OPERATIONREF, OP_NOT_FOUND_ERR, new Object[]{operationId});
        }
        return operation;
    }

    private void checkTargetOperationParameters(Operation operation, Link link, ValidationResults results) {
        for (String paramName : link.getParameters().keySet()) {
            boolean hasParameter = false;
            if (operation.hasParameters()) {
                for (Parameter param : operation.getParameters()) {
                    if (!paramName.equals(param.getName())) continue;
                    hasParameter = true;
                    break;
                }
            }
            if (hasParameter) continue;
            results.add(PARAM_NOT_FOUND_ERR, new Object[]{paramName});
        }
    }

    Operation getOperationRefContent(OpenApi3 api, String operationRef, ValidationResults results) {
        Reference reference = api.getContext().getReferenceRegistry().getRef(operationRef);
        if (reference == null) {
            results.add(OAI3Keywords.CRUMB_OPERATIONREF, REF_MISSING, new Object[]{operationRef});
        } else {
            try {
                return (Operation)reference.getMappedContent(Operation.class);
            }
            catch (DecodeException e) {
                results.add(OAI3Keywords.CRUMB_OPERATIONREF, REF_CONTENT_UNREADABLE, new Object[]{operationRef});
            }
        }
        return null;
    }
}

