/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.Discriminator;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.DiscriminatorValidator;
import org.openapi4j.parser.validation.v3.ExternalDocsValidator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;
import org.openapi4j.parser.validation.v3.XmlValidator;

class SchemaValidator
extends Validator3Base<OpenApi3, Schema> {
    private static final Pattern TYPE_REGEX = Pattern.compile(String.join((CharSequence)"|", "boolean", "object", "array", "number", "integer", "string"));
    private static final ValidationResult DISCRIM_ONLY_ONE = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(132), "The discriminator mapping '%s' MUST have only one of the composite keywords 'oneOf, anyOf, allOf'");
    private static final ValidationResult DISCRIM_CONSTRAINT_MISSING = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(133), "The discriminator '%s' is not required or not a property of the allOf schemas");
    private static final ValidationResult DISCRIM_PROP_MISSING = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(134), "The discriminator '%s' is not a property of this schema");
    private static final ValidationResult DISCRIM_REQUIRED_MISSING = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(135), "The discriminator '%s' is required in this schema");
    private static final ValidationResult READ_WRITE_ONLY_EXCLUSIVE = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(136), "Schema cannot be both ReadOnly and WriteOnly");
    private static final ValidationResult FORMAT_TYPE_MISMATCH = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(137), "Format '%s' is incompatible with schema type '%s'");
    private static final ValidationResult VALUE_TYPE_MISMATCH = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(138), "Value '%s' is incompatible with schema type '%s'");
    private static final ValidationResults.CrumbInfo CRUMB_ADDITIONALPROPERTIES = new ValidationResults.CrumbInfo("additionalProperties", false);
    private static final ValidationResults.CrumbInfo CRUMB_DISCRIMINATOR = new ValidationResults.CrumbInfo("discriminator", false);
    private static final ValidationResults.CrumbInfo CRUMB_MAXITEMS = new ValidationResults.CrumbInfo("maxItems", false);
    private static final ValidationResults.CrumbInfo CRUMB_MINITEMS = new ValidationResults.CrumbInfo("minItems", false);
    private static final ValidationResults.CrumbInfo CRUMB_MAXLENGTH = new ValidationResults.CrumbInfo("maxLength", false);
    private static final ValidationResults.CrumbInfo CRUMB_MINLENGTH = new ValidationResults.CrumbInfo("minLength", false);
    private static final ValidationResults.CrumbInfo CRUMB_MAXPROPERTIES = new ValidationResults.CrumbInfo("maxProperties", false);
    private static final ValidationResults.CrumbInfo CRUMB_MINPROPERTIES = new ValidationResults.CrumbInfo("minProperties", false);
    private static final ValidationResults.CrumbInfo CRUMB_MULTIPLEOF = new ValidationResults.CrumbInfo("multipleOf", false);
    private static final ValidationResults.CrumbInfo CRUMB_PATTERN = new ValidationResults.CrumbInfo("pattern", false);
    private static final ValidationResults.CrumbInfo CRUMB_PROPERTIES = new ValidationResults.CrumbInfo("properties", false);
    private static final ValidationResults.CrumbInfo CRUMB_ALLOF = new ValidationResults.CrumbInfo("allOf", false);
    private static final ValidationResults.CrumbInfo CRUMB_ANYOF = new ValidationResults.CrumbInfo("anyOf", false);
    private static final ValidationResults.CrumbInfo CRUMB_ONEOF = new ValidationResults.CrumbInfo("oneOf", false);
    private static final ValidationResults.CrumbInfo CRUMB_FORMAT = new ValidationResults.CrumbInfo("format", false);
    private static final Validator<OpenApi3, Schema> INSTANCE = new SchemaValidator();

    private SchemaValidator() {
    }

    public static Validator<OpenApi3, Schema> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Schema schema, ValidationResults results) {
        if (schema.isRef()) {
            this.validateReference(context, api, schema, results, OAI3Keywords.CRUMB_$REF, SchemaValidator.instance(), Schema.class);
        } else {
            this.validateField(context, api, schema.getAdditionalProperties(), results, false, CRUMB_ADDITIONALPROPERTIES, SchemaValidator.instance());
            this.validateField(context, api, schema.getDiscriminator(), results, false, CRUMB_DISCRIMINATOR, DiscriminatorValidator.instance());
            this.checkDiscriminator(api, schema, results);
            this.validateDefaultType(schema.getDefault(), schema.getType(), results);
            this.validateList(context, api, schema.getEnums(), results, false, 1, OAI3Keywords.CRUMB_ENUM, null);
            this.validateMap(context, api, schema.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
            this.validateField(context, api, schema.getExternalDocs(), results, false, OAI3Keywords.CRUMB_EXTERNALDOCS, ExternalDocsValidator.instance());
            this.validateFormat(schema.getFormat(), schema.getType(), results);
            if (schema.getItemsSchema() != null) {
                context.validate(api, schema.getItemsSchema(), SchemaValidator.instance(), results);
            }
            this.validateNonNegative(schema.getMaxItems(), results, false, CRUMB_MAXITEMS);
            this.validateNonNegative(schema.getMinItems(), results, false, CRUMB_MINITEMS);
            this.validateNonNegative(schema.getMaxLength(), results, false, CRUMB_MAXLENGTH);
            this.validateNonNegative(schema.getMinLength(), results, false, CRUMB_MINLENGTH);
            this.validateNonNegative(schema.getMaxProperties(), results, false, CRUMB_MAXPROPERTIES);
            this.validateNonNegative(schema.getMinProperties(), results, false, CRUMB_MINPROPERTIES);
            this.validatePositive(schema.getMultipleOf(), results, false, CRUMB_MULTIPLEOF);
            if (schema.getNotSchema() != null) {
                context.validate(api, schema.getNotSchema(), SchemaValidator.instance(), results);
            }
            this.validatePattern(schema.getPattern(), results, false, CRUMB_PATTERN);
            this.validateMap(context, api, schema.getProperties(), results, false, CRUMB_PROPERTIES, null, this);
            this.validateList(context, api, schema.getRequiredFields(), results, false, 1, OAI3Keywords.CRUMB_REQUIRED, null);
            this.validateList(context, api, schema.getAllOfSchemas(), results, false, 1, CRUMB_ALLOF, this);
            this.validateList(context, api, schema.getAnyOfSchemas(), results, false, 1, CRUMB_ANYOF, this);
            this.validateList(context, api, schema.getOneOfSchemas(), results, false, 1, CRUMB_ONEOF, this);
            this.checkReadWrite(schema, results);
            this.validateString(schema.getType(), results, false, TYPE_REGEX, OAI3Keywords.CRUMB_TYPE);
            this.validateField(context, api, schema.getXml(), results, false, OAI3Keywords.CRUMB_XML, XmlValidator.instance());
        }
    }

    private void checkDiscriminator(OpenApi3 api, Schema schema, ValidationResults results) {
        Discriminator discriminator = schema.getDiscriminator();
        if (discriminator == null) {
            return;
        }
        int count = 0;
        count += schema.hasAllOfSchemas() ? 1 : 0;
        count += schema.hasAnyOfSchemas() ? 1 : 0;
        if ((count += schema.hasOneOfSchemas() ? 1 : 0) > 1) {
            results.add(CRUMB_DISCRIMINATOR, DISCRIM_ONLY_ONE, new Object[]{discriminator.getPropertyName()});
        } else if (count == 0) {
            this.checkSchemaDiscriminator(api, discriminator, Collections.singletonList(schema), results);
        } else {
            this.checkSchemaCollections(api, schema, discriminator, results);
        }
    }

    private void checkSchemaCollections(OpenApi3 api, Schema schema, Discriminator discriminator, ValidationResults results) {
        if (schema.hasAllOfSchemas()) {
            if (!this.checkSchemaDiscriminator(api, discriminator, schema.getAllOfSchemas(), new ValidationResults())) {
                results.add(CRUMB_DISCRIMINATOR, DISCRIM_CONSTRAINT_MISSING, new Object[]{discriminator.getPropertyName()});
            }
        } else if (schema.hasAnyOfSchemas()) {
            this.checkSchemaDiscriminator(api, discriminator, schema.getAnyOfSchemas(), results);
        } else {
            this.checkSchemaDiscriminator(api, discriminator, schema.getOneOfSchemas(), results);
        }
    }

    private boolean checkSchemaDiscriminator(OpenApi3 api, Discriminator discriminator, List<Schema> schemas, ValidationResults results) {
        boolean hasProperty;
        block2: {
            Schema schema;
            block3: {
                hasProperty = true;
                Iterator<Schema> iterator = schemas.iterator();
                if (!iterator.hasNext()) break block2;
                schema = iterator.next();
                if (schema.isRef()) {
                    schema = this.getReferenceContent(api, schema, results, CRUMB_DISCRIMINATOR, Schema.class);
                }
                if (!schema.hasAllOfSchemas()) break block3;
                if (this.checkSchemaDiscriminator(api, discriminator, schema.getAllOfSchemas(), new ValidationResults())) break block2;
                results.add(CRUMB_DISCRIMINATOR, DISCRIM_CONSTRAINT_MISSING, new Object[]{discriminator.getPropertyName()});
                hasProperty = false;
                break block2;
            }
            if (!schema.hasProperty(discriminator.getPropertyName())) {
                results.add(CRUMB_DISCRIMINATOR, DISCRIM_PROP_MISSING, new Object[]{discriminator.getPropertyName()});
                hasProperty = false;
            }
            if (schema.hasRequiredFields() && schema.getRequiredFields().contains(discriminator.getPropertyName())) break block2;
            results.add(CRUMB_DISCRIMINATOR, DISCRIM_REQUIRED_MISSING, new Object[]{discriminator.getPropertyName()});
            hasProperty = false;
        }
        return hasProperty;
    }

    private void checkReadWrite(Schema schema, ValidationResults results) {
        if (schema.isReadOnly() && schema.isWriteOnly()) {
            results.add(READ_WRITE_ONLY_EXCLUSIVE, new Object[0]);
        }
    }

    private void validateFormat(String format, String type, ValidationResults results) {
        if (format != null) {
            String expectedType;
            switch (format) {
                case "int32": 
                case "int64": {
                    expectedType = "integer";
                    break;
                }
                case "float": 
                case "double": {
                    expectedType = "number";
                    break;
                }
                default: {
                    expectedType = "string";
                }
            }
            if (type != null && !type.equals(expectedType)) {
                results.add(CRUMB_FORMAT, FORMAT_TYPE_MISMATCH, new Object[]{format, type});
            }
        }
    }

    private void validateDefaultType(Object defaultValue, String type, ValidationResults results) {
        if (defaultValue != null && type != null) {
            boolean ok;
            switch (type) {
                case "string": {
                    ok = defaultValue instanceof String;
                    break;
                }
                case "number": {
                    ok = defaultValue instanceof Number;
                    break;
                }
                case "integer": {
                    ok = defaultValue instanceof Integer;
                    break;
                }
                case "boolean": {
                    ok = defaultValue instanceof Boolean;
                    break;
                }
                case "object": {
                    ok = defaultValue instanceof Map;
                    break;
                }
                default: {
                    ok = defaultValue instanceof Collection;
                }
            }
            if (!ok) {
                results.add(OAI3Keywords.CRUMB_DEFAULT, VALUE_TYPE_MISMATCH, new Object[]{defaultValue, type});
            }
        }
    }
}

