/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OAuthFlow;
import org.openapi4j.parser.model.v3.OAuthFlows;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.SecurityScheme;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.OAuthFlowValidator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class SecuritySchemeValidator
extends Validator3Base<OpenApi3, SecurityScheme> {
    private static final ValidationResult OAUTH_FLOW_REQUIRED = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(141), "At least one OAuth flow is required");
    private static final Pattern TYPE_REGEX = Pattern.compile(String.join((CharSequence)"|", "apiKey", "http", "oauth2", "openIdConnect"));
    private static final Pattern IN_REGEX = Pattern.compile(String.join((CharSequence)"|", "query", "header", "cookie"));
    private static final Validator<OpenApi3, SecurityScheme> INSTANCE = new SecuritySchemeValidator();

    private SecuritySchemeValidator() {
    }

    public static Validator<OpenApi3, SecurityScheme> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, SecurityScheme securityScheme, ValidationResults results) {
        if (securityScheme.isRef()) {
            this.validateReference(context, api, securityScheme, results, OAI3Keywords.CRUMB_$REF, SecuritySchemeValidator.instance(), SecurityScheme.class);
        } else {
            this.validateString(securityScheme.getType(), results, true, TYPE_REGEX, OAI3Keywords.CRUMB_TYPE);
            if (securityScheme.getType() != null) {
                String s = securityScheme.getType();
                if ("http".equals(s)) {
                    this.validateString(securityScheme.getScheme(), results, true, OAI3Keywords.CRUMB_SCHEME);
                } else if ("apiKey".equals(s)) {
                    this.validateString(securityScheme.getName(), results, true, OAI3Keywords.CRUMB_NAME);
                    this.validateString(securityScheme.getIn(), results, true, IN_REGEX, OAI3Keywords.CRUMB_IN);
                } else if ("oauth2".equals(s)) {
                    OAuthFlows flows = securityScheme.getFlows();
                    Validator<OpenApi3, OAuthFlow> flowValidator = OAuthFlowValidator.instance();
                    this.validateField(context, api, flows.getAuthorizationCode(), results, false, OAI3Keywords.CRUMB_AUTHORIZATIONCODE, flowValidator);
                    this.validateField(context, api, flows.getClientCredentials(), results, false, OAI3Keywords.CRUMB_CLIENTCREDENTIALS, flowValidator);
                    this.validateField(context, api, flows.getImplicit(), results, false, OAI3Keywords.CRUMB_IMPLICIT, flowValidator);
                    this.validateField(context, api, flows.getPassword(), results, false, OAI3Keywords.CRUMB_PASSWORD, flowValidator);
                    this.validateMap(context, api, flows.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
                    if (flows.getAuthorizationCode() == null && flows.getClientCredentials() == null && flows.getImplicit() == null && flows.getPassword() == null) {
                        results.add(OAI3Keywords.CRUMB_FLOWS, OAUTH_FLOW_REQUIRED, new Object[0]);
                    }
                } else if ("openIdConnect".equals(s)) {
                    this.validateUrl(api, securityScheme.getOpenIdConnectUrl(), results, true, true, OAI3Keywords.CRUMB_OPENIDCONNECTURL);
                }
            }
            this.validateMap(context, api, securityScheme.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
        }
    }
}

