/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Server;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.OAI3Keywords;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.ServerVariableValidator;
import org.openapi4j.parser.validation.v3.Validator3Base;

class ServerValidator
extends Validator3Base<OpenApi3, Server> {
    private static final ValidationResult VARIABLE_NOT_DEFINED = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(142), "Undefined variable '%s' for url '%s'");
    private static final ValidationResult VARIABLES_NOT_DEFINED = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(143), "Undefined variables for url '%s'");
    private static final Pattern PATTERN_VARIABLES = Pattern.compile("(\\{)(.*?)(})");
    private static final Validator<OpenApi3, Server> INSTANCE = new ServerValidator();

    private ServerValidator() {
    }

    public static Validator<OpenApi3, Server> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(ValidationContext<OpenApi3> context, OpenApi3 api, Server server, ValidationResults results) {
        this.checkUrlWithVariables(api, server, results);
        this.validateMap(context, api, server.getVariables(), results, false, OAI3Keywords.CRUMB_VARIABLES, Regexes.NAME_REGEX, ServerVariableValidator.instance());
        this.validateMap(context, api, server.getExtensions(), results, false, OAI3Keywords.CRUMB_EXTENSIONS, Regexes.EXT_REGEX, null);
    }

    private void checkUrlWithVariables(OpenApi3 api, Server server, ValidationResults results) {
        String url = server.getUrl();
        this.validateUrl(api, url, results, true, true, OAI3Keywords.CRUMB_URL);
        Matcher matcher = PATTERN_VARIABLES.matcher(url);
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            variables.add(matcher.group(2));
        }
        if (!variables.isEmpty() && server.getVariables() == null) {
            results.add(OAI3Keywords.CRUMB_URL, VARIABLES_NOT_DEFINED, new Object[]{url});
        } else if (server.getVariables() != null) {
            for (String variable : variables) {
                if (server.getVariables().containsKey(variable)) continue;
                results.add(OAI3Keywords.CRUMB_URL, VARIABLE_NOT_DEFINED, new Object[]{variable, url});
            }
        }
    }
}

