/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import java.net.MalformedURLException;
import java.net.URL;
import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.AbsRefOpenApiSchema;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.ValidationContext;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.ValidatorBase;

abstract class Validator3Base<O extends OpenApi3, T>
extends ValidatorBase<O, T> {
    private static final ValidationResult INVALID_URL = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(108), "Invalid URL '%s'");
    protected static final ValidationResult REF_MISSING = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(109), "Missing $ref '%s'");
    protected static final ValidationResult REF_CONTENT_UNREADABLE = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(110), "Unable to read $ref content for '%s' pointer.");
    private static final ValidationResult INVALID_RELATIVE_URL = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(145), "Invalid relative URL '%s', no server URL defined.");

    Validator3Base() {
    }

    <F extends OpenApiSchema<F>> F getReferenceContent(O api, AbsRefOpenApiSchema<F> schema, ValidationResults results, ValidationResults.CrumbInfo crumbInfo, Class<F> clazz) {
        Reference reference = schema.getReference(((OpenApi3)api).getContext());
        if (reference == null) {
            results.add(crumbInfo, REF_MISSING, new Object[]{schema.getRef()});
        } else {
            try {
                return (F)((OpenApiSchema)reference.getMappedContent(clazz));
            }
            catch (DecodeException e) {
                results.add(crumbInfo, REF_CONTENT_UNREADABLE, new Object[]{schema.getRef()});
            }
        }
        return null;
    }

    <F extends OpenApiSchema<F>> void validateReference(ValidationContext<OpenApi3> context, O api, AbsRefOpenApiSchema<F> schema, ValidationResults results, ValidationResults.CrumbInfo crumbInfo, Validator<OpenApi3, F> validator, Class<F> clazz) {
        F content = this.getReferenceContent(api, schema, results, crumbInfo, clazz);
        if (content != null) {
            context.validate((OpenApi3)api, content, validator, results);
        }
    }

    protected void validateUrl(O api, String value, ValidationResults results, boolean required, boolean allowRelative, ValidationResults.CrumbInfo crumbInfo) {
        this.validateString(value, results, required, null, crumbInfo);
        if (value != null) {
            this.checkUrl(api, value, allowRelative, results, crumbInfo);
        }
    }

    private void checkUrl(O api, String urlSpec, boolean allowRelative, ValidationResults results, ValidationResults.CrumbInfo crumbInfo) {
        try {
            new URL(urlSpec);
        }
        catch (MalformedURLException e) {
            if (!allowRelative) {
                results.add(crumbInfo, INVALID_URL, new Object[]{urlSpec});
            }
            if (!((OpenApi3)api).hasServers()) {
                results.add(crumbInfo, INVALID_RELATIVE_URL, new Object[]{urlSpec});
            }
            String serverUrl = ((OpenApi3)api).getServers().get(0).getUrl();
            if (serverUrl == null) {
                results.add(crumbInfo, INVALID_RELATIVE_URL, new Object[]{urlSpec});
            }
            try {
                new URL(new URL(serverUrl), urlSpec);
            }
            catch (MalformedURLException ignored) {
                results.add(crumbInfo, INVALID_URL, new Object[]{serverUrl + urlSpec});
            }
        }
    }
}

