/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.images.clustseg;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.connectedcomponent.GreyscaleConnectedComponentLabeler;
import org.openimaj.image.pixel.PixelSet;
import org.openimaj.image.typography.Font;
import org.openimaj.image.typography.hershey.HersheyFont;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.ml.clustering.FloatCentroidsResult;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.kmeans.FloatKMeans;

public class App {
    public static void main(String[] args) throws IOException {
        float[][] centroids;
        MBFImage input = ImageUtilities.readMBF((URL)new URL("http://static.openimaj.org/media/tutorial/sinaface.jpg"));
        input = ColourSpace.convert((MBFImage)input, (ColourSpace)ColourSpace.CIE_Lab);
        FloatKMeans cluster = FloatKMeans.createExact((int)3, (int)2);
        float[][] imageData = input.getPixelVectorNative(new float[input.getWidth() * input.getHeight()][3]);
        FloatCentroidsResult result = cluster.cluster(imageData);
        for (float[] fs : centroids = result.centroids) {
            System.out.println(Arrays.toString(fs));
        }
        HardAssigner assigner = result.defaultHardAssigner();
        for (int y = 0; y < input.getHeight(); ++y) {
            for (int x = 0; x < input.getWidth(); ++x) {
                float[] pixel = input.getPixelNative(x, y);
                int centroid = assigner.assign((Object)pixel);
                input.setPixelNative(x, y, centroids[centroid]);
            }
        }
        input = ColourSpace.convert((MBFImage)input, (ColourSpace)ColourSpace.RGB);
        DisplayUtilities.display((Image)input);
        GreyscaleConnectedComponentLabeler labeler = new GreyscaleConnectedComponentLabeler();
        List components = labeler.findComponents(input.flatten());
        int i = 0;
        for (PixelSet comp : components) {
            if (comp.calculateArea() < 50) continue;
            input.drawText("Point:" + i++, (Point2d)comp.calculateCentroidPixel(), (Font)HersheyFont.TIMES_MEDIUM, 20);
        }
        DisplayUtilities.display((Image)input);
    }
}

