/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.adv.faces.pipeeigen;

import java.io.IOException;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.VFSGroupDataset;
import org.openimaj.experiment.dataset.split.GroupedRandomSplitter;
import org.openimaj.feature.DoubleFVComparator;
import org.openimaj.feature.DoubleFVComparison;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.alignment.IdentityAligner;
import org.openimaj.image.processing.face.detection.FaceDetector;
import org.openimaj.image.processing.face.detection.IdentityFaceDetector;
import org.openimaj.image.processing.face.recognition.EigenFaceRecogniser;
import org.openimaj.image.processing.face.recognition.FaceRecogniser;
import org.openimaj.image.processing.face.recognition.FaceRecognitionEngine;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.util.pair.IndependentPair;

public class App {
    public static void main(String[] args) throws IOException {
        VFSGroupDataset dataset = new VFSGroupDataset("zip:http://datasets.openimaj.org/att_faces.zip", ImageUtilities.FIMAGE_READER);
        GroupedRandomSplitter splits = new GroupedRandomSplitter((GroupedDataset)dataset, 5, 0, 5);
        GroupedDataset training = splits.getTrainingDataset();
        GroupedDataset testing = splits.getTestDataset();
        IdentityAligner aligner = new IdentityAligner();
        IdentityFaceDetector detector = new IdentityFaceDetector();
        EigenFaceRecogniser recogniser = EigenFaceRecogniser.create((int)100, (FaceAligner)aligner, (int)1, (DoubleFVComparator)DoubleFVComparison.EUCLIDEAN);
        FaceRecognitionEngine engine = new FaceRecognitionEngine((FaceDetector)detector, (FaceRecogniser)recogniser);
        engine.train(training);
        double correct = 0.0;
        double incorrect = 0.0;
        for (String truePerson : testing.getGroups()) {
            for (FImage face : (ListDataset)testing.get((Object)truePerson)) {
                System.out.println(engine.recogniseBest(face));
                String bestPerson = (String)((ScoredAnnotation)((IndependentPair)engine.recogniseBest((FImage)face).get((int)0)).secondObject()).annotation;
                System.out.println("Actual: " + truePerson + "\tguess: " + bestPerson);
                if (truePerson.equals(bestPerson)) {
                    correct += 1.0;
                    continue;
                }
                incorrect += 1.0;
            }
        }
        System.out.println("Accuracy: " + correct / (correct + incorrect));
    }
}

