/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.docs.tutorial.fund.stream.twitterimages;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.image.DisplayUtilities;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.HaarCascadeDetector;
import org.openimaj.stream.functions.ImageFromURL;
import org.openimaj.stream.functions.ImageSiteURLExtractor;
import org.openimaj.stream.functions.twitter.TwitterURLExtractor;
import org.openimaj.stream.provider.twitter.TwitterStreamDataset;
import org.openimaj.util.api.auth.DefaultTokenFactory;
import org.openimaj.util.api.auth.common.TwitterAPIToken;
import org.openimaj.util.function.MultiFunction;
import org.openimaj.util.function.Operation;
import org.openimaj.util.stream.Stream;

public class App {
    public static void main(String[] args) throws FileNotFoundException, UnsupportedEncodingException {
        TwitterAPIToken token = (TwitterAPIToken)DefaultTokenFactory.get(TwitterAPIToken.class);
        TwitterStreamDataset stream = new TwitterStreamDataset(token);
        Stream urlStream = stream.map((MultiFunction)new TwitterURLExtractor());
        Stream imageUrlStream = urlStream.map((MultiFunction)new ImageSiteURLExtractor(false));
        Stream imageStream = imageUrlStream.map((MultiFunction)ImageFromURL.MBFIMAGE_EXTRACTOR);
        imageStream.map((MultiFunction)new MultiFunction<MBFImage, MBFImage>(){
            HaarCascadeDetector detector = HaarCascadeDetector.BuiltInCascade.frontalface_default.load();

            public List<MBFImage> apply(MBFImage in) {
                List detected = this.detector.detectFaces(in.flatten());
                ArrayList<MBFImage> faces = new ArrayList<MBFImage>();
                for (DetectedFace face : detected) {
                    faces.add((MBFImage)in.extractROI(face.getBounds()));
                }
                return faces;
            }
        }).forEach((Operation)new Operation<MBFImage>(){

            public void perform(MBFImage image) {
                DisplayUtilities.displayName((Image)image, (String)"image", (boolean)true);
            }
        });
    }
}

