/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.AtomContainerDiff;

public class AtomContainerDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IAtomContainer container = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        Mockito.when((Object)container.getElectronContainerCount()).thenReturn((Object)1);
        Mockito.when((Object)container.getElectronContainer(0)).thenReturn(Mockito.mock(IBond.class));
        String result = AtomContainerDiff.diff((IChemObject)container, (IChemObject)container);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IAtom carbon = (IAtom)Mockito.mock(IAtom.class);
        IAtom oxygen = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)carbon.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)oxygen.getSymbol()).thenReturn((Object)"O");
        IBond b1 = (IBond)Mockito.mock(IBond.class);
        IBond b2 = (IBond)Mockito.mock(IBond.class);
        Mockito.when((Object)b1.getOrder()).thenReturn((Object)IBond.Order.SINGLE);
        Mockito.when((Object)b2.getOrder()).thenReturn((Object)IBond.Order.DOUBLE);
        Mockito.when((Object)b1.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)b2.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)b1.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)b1.getEnd()).thenReturn((Object)carbon);
        Mockito.when((Object)b2.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)b2.getEnd()).thenReturn((Object)oxygen);
        IAtomContainer container1 = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtomContainer container2 = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        Mockito.when((Object)container1.getElectronContainerCount()).thenReturn((Object)1);
        Mockito.when((Object)container2.getElectronContainerCount()).thenReturn((Object)1);
        Mockito.when((Object)container1.getElectronContainer(0)).thenReturn((Object)b1);
        Mockito.when((Object)container2.getElectronContainer(0)).thenReturn((Object)b2);
        String result = AtomContainerDiff.diff((IChemObject)container1, (IChemObject)container2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "AtomContainerDiff");
        this.assertContains(result, "BondDiff");
        this.assertContains(result, "SINGLE/DOUBLE");
        this.assertContains(result, "AtomDiff");
        this.assertContains(result, "C/O");
    }

    @Test
    public void testDifference() {
        IAtom carbon = (IAtom)Mockito.mock(IAtom.class);
        IAtom oxygen = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)carbon.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)oxygen.getSymbol()).thenReturn((Object)"O");
        IBond b1 = (IBond)Mockito.mock(IBond.class);
        IBond b2 = (IBond)Mockito.mock(IBond.class);
        Mockito.when((Object)b1.getOrder()).thenReturn((Object)IBond.Order.SINGLE);
        Mockito.when((Object)b2.getOrder()).thenReturn((Object)IBond.Order.DOUBLE);
        Mockito.when((Object)b1.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)b2.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)b1.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)b1.getEnd()).thenReturn((Object)carbon);
        Mockito.when((Object)b2.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)b2.getEnd()).thenReturn((Object)oxygen);
        IAtomContainer container1 = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        IAtomContainer container2 = (IAtomContainer)Mockito.mock(IAtomContainer.class);
        Mockito.when((Object)container1.getElectronContainerCount()).thenReturn((Object)1);
        Mockito.when((Object)container2.getElectronContainerCount()).thenReturn((Object)1);
        Mockito.when((Object)container1.getElectronContainer(0)).thenReturn((Object)b1);
        Mockito.when((Object)container2.getElectronContainer(0)).thenReturn((Object)b2);
        String result = AtomContainerDiff.diff((IChemObject)container1, (IChemObject)container2);
        Assert.assertNotNull((Object)result);
    }

    @Ignore(value="unit test did not test AtomContainerDiff but rather the ability of AtomContainerto be serialized. This is already tested in each respective domain module")
    public void testDiffFromSerialized() throws IOException, ClassNotFoundException {
    }
}

