/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.AtomTypeDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class AtomTypeDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IAtomType element1 = (IAtomType)Mockito.mock(IAtomType.class);
        String result = AtomTypeDiff.diff((IChemObject)element1, (IChemObject)element1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IAtomType element1 = (IAtomType)Mockito.mock(IAtomType.class);
        IAtomType element2 = (IAtomType)Mockito.mock(IAtomType.class);
        Mockito.when((Object)element1.getHybridization()).thenReturn((Object)IAtomType.Hybridization.PLANAR3);
        Mockito.when((Object)element2.getHybridization()).thenReturn((Object)IAtomType.Hybridization.SP3);
        String result = AtomTypeDiff.diff((IChemObject)element1, (IChemObject)element2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "AtomTypeDiff");
        this.assertContains(result, "PLANAR3/SP3");
    }

    @Test
    public void testDifference() {
        IAtomType element1 = (IAtomType)Mockito.mock(IAtomType.class);
        IAtomType element2 = (IAtomType)Mockito.mock(IAtomType.class);
        Mockito.when((Object)element1.getHybridization()).thenReturn((Object)IAtomType.Hybridization.PLANAR3);
        Mockito.when((Object)element2.getHybridization()).thenReturn((Object)IAtomType.Hybridization.SP3);
        IDifference difference = AtomTypeDiff.difference((IChemObject)element1, (IChemObject)element2);
        Assert.assertNotNull((Object)difference);
    }
}

