/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.BondDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class BondDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IBond bond1 = (IBond)Mockito.mock(IBond.class);
        String result = BondDiff.diff((IChemObject)bond1, (IChemObject)bond1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IAtom carbon = (IAtom)Mockito.mock(IAtom.class);
        IAtom oxygen = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)carbon.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)oxygen.getSymbol()).thenReturn((Object)"O");
        IBond bond1 = (IBond)Mockito.mock(IBond.class);
        IBond bond2 = (IBond)Mockito.mock(IBond.class);
        Mockito.when((Object)bond1.getOrder()).thenReturn((Object)IBond.Order.SINGLE);
        Mockito.when((Object)bond2.getOrder()).thenReturn((Object)IBond.Order.DOUBLE);
        Mockito.when((Object)bond1.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)bond2.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)bond1.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)bond1.getEnd()).thenReturn((Object)carbon);
        Mockito.when((Object)bond2.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)bond2.getEnd()).thenReturn((Object)oxygen);
        bond1.setOrder(IBond.Order.SINGLE);
        bond2.setOrder(IBond.Order.DOUBLE);
        String result = BondDiff.diff((IChemObject)bond1, (IChemObject)bond2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "BondDiff");
        this.assertContains(result, "SINGLE/DOUBLE");
        this.assertContains(result, "AtomDiff");
        this.assertContains(result, "C/O");
    }

    @Test
    public void testDifference() {
        IAtom carbon = (IAtom)Mockito.mock(IAtom.class);
        IAtom oxygen = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)carbon.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)oxygen.getSymbol()).thenReturn((Object)"O");
        IBond bond1 = (IBond)Mockito.mock(IBond.class);
        IBond bond2 = (IBond)Mockito.mock(IBond.class);
        Mockito.when((Object)bond1.getOrder()).thenReturn((Object)IBond.Order.SINGLE);
        Mockito.when((Object)bond2.getOrder()).thenReturn((Object)IBond.Order.DOUBLE);
        Mockito.when((Object)bond1.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)bond2.getAtomCount()).thenReturn((Object)2);
        Mockito.when((Object)bond1.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)bond1.getEnd()).thenReturn((Object)carbon);
        Mockito.when((Object)bond2.getBegin()).thenReturn((Object)carbon);
        Mockito.when((Object)bond2.getEnd()).thenReturn((Object)oxygen);
        bond1.setOrder(IBond.Order.SINGLE);
        bond2.setOrder(IBond.Order.DOUBLE);
        IDifference difference = BondDiff.difference((IChemObject)bond1, (IChemObject)bond2);
        Assert.assertNotNull((Object)difference);
    }
}

