/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.tools.diff.ElectronContainerDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class ElectronContainerDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IElectronContainer atom1 = (IElectronContainer)Mockito.mock(IElectronContainer.class);
        String result = ElectronContainerDiff.diff((IChemObject)atom1, (IChemObject)atom1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IElectronContainer ec1 = (IElectronContainer)Mockito.mock(IElectronContainer.class);
        IElectronContainer ec2 = (IElectronContainer)Mockito.mock(IElectronContainer.class);
        Mockito.when((Object)ec1.getElectronCount()).thenReturn((Object)2);
        Mockito.when((Object)ec2.getElectronCount()).thenReturn((Object)3);
        String result = ElectronContainerDiff.diff((IChemObject)ec1, (IChemObject)ec2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "ElectronContainerDiff");
        this.assertContains(result, "eCount");
        this.assertContains(result, "2/3");
    }

    @Test
    public void testDifference() {
        IElectronContainer ec1 = (IElectronContainer)Mockito.mock(IElectronContainer.class);
        IElectronContainer ec2 = (IElectronContainer)Mockito.mock(IElectronContainer.class);
        Mockito.when((Object)ec1.getElectronCount()).thenReturn((Object)2);
        Mockito.when((Object)ec2.getElectronCount()).thenReturn((Object)3);
        IDifference difference = ElectronContainerDiff.difference((IChemObject)ec1, (IChemObject)ec2);
        Assert.assertNotNull((Object)difference);
    }
}

