/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.diff.ElementDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class ElementDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IElement element1 = (IElement)Mockito.mock(IElement.class);
        String result = ElementDiff.diff((IChemObject)element1, (IChemObject)element1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IElement element1 = (IElement)Mockito.mock(IElement.class);
        IElement element2 = (IElement)Mockito.mock(IElement.class);
        Mockito.when((Object)element1.getSymbol()).thenReturn((Object)"H");
        Mockito.when((Object)element2.getSymbol()).thenReturn((Object)"C");
        String result = ElementDiff.diff((IChemObject)element1, (IChemObject)element2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "ElementDiff");
        this.assertContains(result, "H/C");
    }

    @Test
    public void testDifference() {
        IElement element1 = (IElement)Mockito.mock(IElement.class);
        IElement element2 = (IElement)Mockito.mock(IElement.class);
        Mockito.when((Object)element1.getSymbol()).thenReturn((Object)"H");
        Mockito.when((Object)element2.getSymbol()).thenReturn((Object)"C");
        IDifference difference = ElementDiff.difference((IChemObject)element1, (IChemObject)element2);
        Assert.assertNotNull((Object)difference);
    }
}

