/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.tools.diff.LonePairDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class LonePairDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        ILonePair bond1 = (ILonePair)Mockito.mock(ILonePair.class);
        String result = LonePairDiff.diff((IChemObject)bond1, (IChemObject)bond1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IAtom carbon = (IAtom)Mockito.mock(IAtom.class);
        IAtom oxygen = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)carbon.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)oxygen.getSymbol()).thenReturn((Object)"O");
        ILonePair bond1 = (ILonePair)Mockito.mock(ILonePair.class);
        ILonePair bond2 = (ILonePair)Mockito.mock(ILonePair.class);
        Mockito.when((Object)bond1.getAtom()).thenReturn((Object)carbon);
        Mockito.when((Object)bond2.getAtom()).thenReturn((Object)oxygen);
        String result = LonePairDiff.diff((IChemObject)bond1, (IChemObject)bond2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "LonePairDiff");
        this.assertContains(result, "AtomDiff");
        this.assertContains(result, "C/O");
    }

    @Test
    public void testDifference() {
        IAtom carbon = (IAtom)Mockito.mock(IAtom.class);
        IAtom oxygen = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)carbon.getSymbol()).thenReturn((Object)"C");
        Mockito.when((Object)oxygen.getSymbol()).thenReturn((Object)"O");
        ILonePair bond1 = (ILonePair)Mockito.mock(ILonePair.class);
        ILonePair bond2 = (ILonePair)Mockito.mock(ILonePair.class);
        Mockito.when((Object)bond1.getAtom()).thenReturn((Object)carbon);
        Mockito.when((Object)bond2.getAtom()).thenReturn((Object)oxygen);
        IDifference difference = LonePairDiff.difference((IChemObject)bond1, (IChemObject)bond2);
        Assert.assertNotNull((Object)difference);
    }
}

