/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.AtomDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class AtomDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IAtom atom1 = (IAtom)Mockito.mock(IAtom.class);
        String result = AtomDiff.diff((IChemObject)atom1, (IChemObject)atom1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IAtom atom1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom atom2 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom1.getSymbol()).thenReturn((Object)"H");
        Mockito.when((Object)atom2.getSymbol()).thenReturn((Object)"C");
        String result = AtomDiff.diff((IChemObject)atom1, (IChemObject)atom2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "AtomDiff");
        this.assertContains(result, "H/C");
    }

    @Test
    public void testDifference() {
        IAtom atom1 = (IAtom)Mockito.mock(IAtom.class);
        IAtom atom2 = (IAtom)Mockito.mock(IAtom.class);
        Mockito.when((Object)atom1.getSymbol()).thenReturn((Object)"H");
        Mockito.when((Object)atom2.getSymbol()).thenReturn((Object)"C");
        IDifference difference = AtomDiff.difference((IChemObject)atom1, (IChemObject)atom2);
        Assert.assertNotNull((Object)difference);
    }

    @Ignore(value="unit test did not test AtomDiff but rather the ability of AtomContainerto be serialized. This is already tested in each respective domain module")
    public void testDiffFromSerialized() throws IOException, ClassNotFoundException {
    }
}

