/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.ChemObjectDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class ChemObjectDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IChemObject atom1 = (IChemObject)Mockito.mock(IChemObject.class);
        String result = ChemObjectDiff.diff((IChemObject)atom1, (IChemObject)atom1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IChemObject atom1 = (IChemObject)Mockito.mock(IChemObject.class);
        IChemObject atom2 = (IChemObject)Mockito.mock(IChemObject.class);
        Mockito.when((Object)atom1.getFlags()).thenReturn((Object)new boolean[]{false, false, false});
        Mockito.when((Object)atom2.getFlags()).thenReturn((Object)new boolean[]{false, true, false});
        String result = ChemObjectDiff.diff((IChemObject)atom1, (IChemObject)atom2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((String)"Expected non-zero-length result", (Object)0, (Object)result.length());
        this.assertContains(result, "ChemObjectDiff");
        this.assertContains(result, "F/T");
    }

    @Test
    public void testDifference() {
        IChemObject atom1 = (IChemObject)Mockito.mock(IChemObject.class);
        IChemObject atom2 = (IChemObject)Mockito.mock(IChemObject.class);
        Mockito.when((Object)atom1.getFlags()).thenReturn((Object)new boolean[]{false, false, false});
        Mockito.when((Object)atom2.getFlags()).thenReturn((Object)new boolean[]{false, true, false});
        IDifference difference = ChemObjectDiff.difference((IChemObject)atom1, (IChemObject)atom2);
        Assert.assertNotNull((Object)difference);
    }
}

