/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.diff.IsotopeDiff;
import org.openscience.cdk.tools.diff.tree.IDifference;

public class IsotopeDiffTest
extends CDKTestCase {
    @Test
    public void testMatchAgainstItself() {
        IIsotope element1 = (IIsotope)Mockito.mock(IIsotope.class);
        String result = IsotopeDiff.diff((IChemObject)element1, (IChemObject)element1);
        this.assertZeroLength(result);
    }

    @Test
    public void testDiff() {
        IIsotope element1 = (IIsotope)Mockito.mock(IIsotope.class);
        IIsotope element2 = (IIsotope)Mockito.mock(IIsotope.class);
        Mockito.when((Object)element1.getSymbol()).thenReturn((Object)"H");
        Mockito.when((Object)element2.getSymbol()).thenReturn((Object)"C");
        String result = IsotopeDiff.diff((IChemObject)element1, (IChemObject)element2);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)0, (Object)result.length());
        this.assertContains(result, "IsotopeDiff");
        this.assertContains(result, "H/C");
    }

    @Test
    public void testDifference() {
        IIsotope element1 = (IIsotope)Mockito.mock(IIsotope.class);
        IIsotope element2 = (IIsotope)Mockito.mock(IIsotope.class);
        Mockito.when((Object)element1.getSymbol()).thenReturn((Object)"H");
        Mockito.when((Object)element2.getSymbol()).thenReturn((Object)"C");
        IDifference difference = IsotopeDiff.difference((IChemObject)element1, (IChemObject)element2);
        Assert.assertNotNull((Object)difference);
    }
}

