/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;

public class IntegerDifferenceTest
extends CDKTestCase {
    @Test
    public void testDiff() {
        IDifference result = IntegerDifference.construct((String)"Foo", (Integer)1, (Integer)2);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSame() {
        IDifference result = IntegerDifference.construct((String)"Foo", (Integer)1, (Integer)1);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testTwoNull() {
        IDifference result = IntegerDifference.construct((String)"Foo", null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testOneNull() {
        IDifference result = IntegerDifference.construct((String)"Foo", null, (Integer)1);
        Assert.assertNotNull((Object)result);
        result = IntegerDifference.construct((String)"Foo", (Integer)2, null);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        IDifference result = IntegerDifference.construct((String)"Foo", (Integer)1, (Integer)2);
        String diffString = result.toString();
        Assert.assertNotNull((Object)diffString);
        this.assertOneLiner(diffString);
    }

    @Test
    public void testRefs() {
        Integer x = new Integer(1);
        Integer y = new Integer(1);
        IDifference diff = IntegerDifference.construct((String)"foo", (Integer)x, (Integer)y);
        Assert.assertNull((Object)diff);
    }
}

