/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.Point2dDifference;

public class Point2dDifferenceTest
extends CDKTestCase {
    @Test
    public void testDiff() {
        Point2d foo = new Point2d(1.0, 2.0);
        Point2d bar = new Point2d(1.0, 5.0);
        IDifference result = Point2dDifference.construct((String)"Foo", (Point2d)foo, (Point2d)bar);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSame() {
        Point2d foo = new Point2d(1.0, 2.0);
        Point2d bar = new Point2d(1.0, 2.0);
        IDifference result = Point2dDifference.construct((String)"Foo", (Point2d)foo, (Point2d)bar);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testTwoNull() {
        IDifference result = Point2dDifference.construct((String)"Foo", null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testOneNull() {
        Point2d bar = new Point2d(1.0, 2.0);
        IDifference result = Point2dDifference.construct((String)"Foo", null, (Point2d)bar);
        Assert.assertNotNull((Object)result);
        result = Point2dDifference.construct((String)"Foo", (Point2d)bar, null);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        Point2d bar = new Point2d(1.0, 5.0);
        IDifference result = Point2dDifference.construct((String)"Foo", null, (Point2d)bar);
        String diffString = result.toString();
        Assert.assertNotNull((Object)diffString);
        this.assertOneLiner(diffString);
    }
}

