/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import javax.vecmath.Point3d;
import org.junit.Assert;
import org.junit.Test;
import org.openscience.cdk.CDKTestCase;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.Point3dDifference;

public class Point3dDifferenceTest
extends CDKTestCase {
    @Test
    public void testDiff() {
        Point3d foo = new Point3d(1.0, 2.0, 4.5);
        Point3d bar = new Point3d(1.0, 5.0, 8.3);
        IDifference result = Point3dDifference.construct((String)"Foo", (Point3d)foo, (Point3d)bar);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSame() {
        Point3d foo = new Point3d(1.0, 2.0, 4.5);
        Point3d bar = new Point3d(1.0, 2.0, 4.5);
        IDifference result = Point3dDifference.construct((String)"Foo", (Point3d)foo, (Point3d)bar);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testTwoNull() {
        IDifference result = Point3dDifference.construct((String)"Foo", null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testOneNull() {
        Point3d bar = new Point3d(1.0, 5.0, 8.3);
        IDifference result = Point3dDifference.construct((String)"Foo", null, (Point3d)bar);
        Assert.assertNotNull((Object)result);
        result = Point3dDifference.construct((String)"Foo", (Point3d)bar, null);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testToString() {
        Point3d bar = new Point3d(1.0, 5.0, 8.3);
        IDifference result = Point3dDifference.construct((String)"Foo", null, (Point3d)bar);
        String diffString = result.toString();
        Assert.assertNotNull((Object)diffString);
        this.assertOneLiner(diffString);
    }
}

