/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.mind.plugin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.objectweb.fractal.adl.ADLException;
import org.objectweb.fractal.adl.CompilerError;
import org.objectweb.fractal.adl.Node;
import org.objectweb.fractal.adl.NodeFactory;
import org.objectweb.fractal.adl.error.ErrorTemplate;
import org.objectweb.fractal.adl.error.GenericErrors;
import org.objectweb.fractal.adl.util.FractalADLLogManager;
import org.ow2.mind.plugin.PluginManager;
import org.ow2.mind.plugin.ast.Extension;
import org.ow2.mind.plugin.ast.ExtensionPoint;
import org.ow2.mind.plugin.ast.Plugin;
import org.ow2.mind.plugin.ast.PluginASTHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPluginManager
implements PluginManager {
    public static final String PLUGIN_XML = "mind-plugin.xml";
    protected PluginRegistry pluginRegistry;
    protected ClassLoader classLoader;
    protected DocumentBuilder builder = null;
    protected static Logger pluginLogger = FractalADLLogManager.getLogger((String)"plugin");
    public NodeFactory nodeFactoryItf;
    public static final String PLUGIN_CLASS_LOADER = "plugin-class-loader";

    public BasicPluginManager() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, (Throwable)e, new Object[]{"Can't initialize document builder"});
        }
    }

    @Override
    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
        this.pluginRegistry = null;
    }

    @Override
    public Collection<Extension> getExtensions(String extensionPoint, Map<Object, Object> context) throws ADLException {
        Collection<Extension> oo = this.getRegistry(context).extensions.get(extensionPoint);
        if (oo != null) {
            return Collections.unmodifiableCollection(oo);
        }
        return Collections.emptySet();
    }

    @Override
    public Collection<String> getExtensionPointNames(Map<Object, Object> context) throws ADLException {
        Set<String> oo = this.getRegistry(context).extensionPoints.keySet();
        if (oo != null) {
            return Collections.unmodifiableCollection(oo);
        }
        return Collections.emptySet();
    }

    protected PluginRegistry initRegistry(Map<Object, Object> context) throws ADLException {
        PluginRegistry registry = new PluginRegistry();
        ClassLoader classLoader = this.classLoader != null ? this.classLoader : this.getClass().getClassLoader();
        Enumeration<URL> plugins = null;
        try {
            plugins = classLoader.getResources(PLUGIN_XML);
        }
        catch (IOException e) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, (Throwable)e, new Object[]{"Can't find plugin descriptors"});
        }
        while (plugins.hasMoreElements()) {
            URL url = plugins.nextElement();
            this.initPlugin(url, registry, context);
        }
        for (Plugin plugin : registry.plugins.values()) {
            if (pluginLogger.isLoggable(Level.FINE)) {
                pluginLogger.fine("Initializing the plugin " + plugin.getId());
            }
            for (Extension extension : plugin.getExtensions()) {
                ExtensionPoint point = registry.extensionPoints.get(extension.getPoint());
                if (point == null) {
                    throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, new Object[]{"Unknown Extenstion point ID \"" + extension.getPoint() + "\" referenced by plugin \"" + plugin.getId() + "\"."});
                }
                registry.extensions.get(extension.getPoint()).add(extension);
            }
        }
        return registry;
    }

    protected void initPlugin(URL pluginDesc, PluginRegistry registry, Map<Object, Object> context) throws ADLException {
        Plugin plugin = this.loadPlugin(pluginDesc);
        Plugin prevPlugin = registry.plugins.put(plugin.getId(), plugin);
        if (prevPlugin != null) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, new Object[]{"Invalid plugin ID \"" + plugin.getId() + "\" A plugin with the same name is already defined."});
        }
        for (ExtensionPoint point : plugin.getExtensionPoints()) {
            ExtensionPoint prevPoint = registry.extensionPoints.put(this.getQualifiedExtensionName(plugin, point), point);
            if (prevPoint != null) {
                throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, new Object[]{"Invalid Extenstion point ID \"" + plugin.getId() + "\" An extension point with the same name is already defined."});
            }
            registry.extensions.put(this.getQualifiedExtensionName(plugin, point), new ArrayList());
        }
    }

    protected String getQualifiedExtensionName(Plugin plugin, ExtensionPoint point) {
        return plugin.getId() + "." + point.getId();
    }

    protected PluginRegistry getRegistry(Map<Object, Object> context) throws ADLException {
        if (this.pluginRegistry == null) {
            this.pluginRegistry = this.initRegistry(context);
        }
        return this.pluginRegistry;
    }

    protected Plugin loadPlugin(URL pluginDesc) throws ADLException {
        Document document = null;
        try {
            document = this.builder.parse(pluginDesc.openStream());
        }
        catch (FileNotFoundException e) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, (Throwable)e, new Object[]{"Unable to find the plugin descriptor '" + pluginDesc + "'."});
        }
        catch (IOException e) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, (Throwable)e, new Object[]{"Unable to access the plugin descriptor '" + pluginDesc + "'."});
        }
        catch (SAXException e) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, (Throwable)e, new Object[]{"Unable to parse the XML plugin descriptor '" + pluginDesc + "'."});
        }
        Element root = document.getDocumentElement();
        Plugin plugin = this.newPluginNode(root.getAttribute("id"), root.getAttribute("name"));
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            org.w3c.dom.Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getNodeName().equals("extension")) {
                Extension extension = this.newExtensionNode(element.getAttribute("point"));
                PluginASTHelper.setExtensionConfig(extension, element);
                plugin.addExtension(extension);
                continue;
            }
            if (!element.getNodeName().equals("extension-point")) continue;
            ExtensionPoint extensionPoint = this.newExtensionPointNode(element.getAttribute("id"), element.getAttribute("dtd"));
            plugin.addExtensionPoint(extensionPoint);
        }
        return plugin;
    }

    protected Plugin newPluginNode(String id, String name) {
        Plugin plugin = BasicPluginManager.newNode(this.nodeFactoryItf, "plugin", Plugin.class, new Class[0]);
        plugin.setId(id);
        plugin.setName(name);
        return plugin;
    }

    protected ExtensionPoint newExtensionPointNode(String id, String dtd) {
        ExtensionPoint extensionPoint = BasicPluginManager.newNode(this.nodeFactoryItf, "extensionPoint", ExtensionPoint.class, new Class[0]);
        extensionPoint.setId(id);
        extensionPoint.setDtd(dtd);
        return extensionPoint;
    }

    protected Extension newExtensionNode(String point) {
        Extension extension = BasicPluginManager.newNode(this.nodeFactoryItf, "extension", Extension.class, new Class[0]);
        extension.setPoint(point);
        return extension;
    }

    protected static <T extends Node> T newNode(NodeFactory nodeFactory, String nodeType, Class<T> nodeItf, Class<?> ... itfs) {
        String[] itfNames = new String[itfs.length + 1];
        itfNames[0] = nodeItf.getName();
        for (int i = 0; i < itfs.length; ++i) {
            itfNames[i + 1] = itfs[i].getName();
        }
        try {
            return (T)((Node)nodeItf.cast(nodeFactory.newNode(nodeType, itfNames)));
        }
        catch (ClassNotFoundException e) {
            throw new CompilerError((ErrorTemplate)GenericErrors.INTERNAL_ERROR, (Throwable)e, new Object[]{"Unexpected error."});
        }
    }

    public static ClassLoader getPluginClassLoader(Map<Object, Object> context) {
        return (ClassLoader)context.get(PLUGIN_CLASS_LOADER);
    }

    public static void setPluginClassLoader(Map<Object, Object> context, ClassLoader classLoader) {
        context.put(PLUGIN_CLASS_LOADER, classLoader);
    }

    protected static final class PluginRegistry {
        final Map<String, Plugin> plugins = new HashMap<String, Plugin>();
        final Map<String, ExtensionPoint> extensionPoints = new HashMap<String, ExtensionPoint>();
        final Map<String, Collection<Extension>> extensions = new HashMap<String, Collection<Extension>>();

        protected PluginRegistry() {
        }
    }
}

