/*
 * Decompiled with CFR 0.152.
 */
package prompto.codeserver;

import java.net.URL;
import java.util.Collection;
import prompto.code.BaseCodeStore;
import prompto.code.ICodeStore;
import prompto.code.QueryableCodeStore;
import prompto.code.Version;
import prompto.codeserver.ModuleImporter;
import prompto.config.IServerConfiguration;
import prompto.config.IStoreConfiguration;
import prompto.libraries.Libraries;
import prompto.server.AppServer;
import prompto.server.DataServlet;
import prompto.store.IDataStore;
import prompto.store.IStore;
import prompto.store.IStoreFactory;
import prompto.utils.ResourceUtils;

public class CodeServer {
    public static void main(String[] args) throws Throwable {
        CodeServer.main(args, false);
    }

    public static void main(String[] args, final boolean testMode) throws Throwable {
        Object config = AppServer.loadConfiguration((String[])args);
        config = new IServerConfiguration.Sourced((IServerConfiguration)config){

            public String getApplicationName() {
                return "dev-center";
            }

            public Version getApplicationVersion() {
                return Version.parse((String)"1.0.0");
            }

            public URL[] getResourceURLs() {
                return CodeServer.getResourceURLs();
            }

            public String getServerAboutToStartMethod() {
                return "serverAboutToStart";
            }

            public boolean isTestMode() {
                return testMode;
            }
        };
        AppServer.main((IServerConfiguration)config, CodeServer::redirectDataServlet);
    }

    private static void redirectDataServlet(IServerConfiguration config) {
        try {
            IStoreConfiguration code = config.getDataStoreConfiguration();
            IStoreFactory factory = IStoreFactory.newStoreFactory((String)code.getFactory());
            DataServlet.store = factory.newStore(code.withDbName("DATA"));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static URL[] getResourceURLs() {
        Collection urls = Libraries.getPromptoLibraries((Class[])new Class[]{BaseCodeStore.class, ModuleImporter.class});
        return urls.toArray(new URL[urls.size()]);
    }

    public static void createThesaurusAndImportSamples() {
        try {
            IStore dataStore = IDataStore.getInstance();
            QueryableCodeStore codeStore = new QueryableCodeStore(dataStore, () -> Libraries.getPromptoLibraries(Libraries.class), "dev-center", Version.parse((String)"1.0.0"), null, new URL[0]);
            ModuleImporter importer = new ModuleImporter(Thread.currentThread().getContextClassLoader().getResource("thesaurus/"));
            importer.importModule((ICodeStore)codeStore);
            Collection samples = ResourceUtils.listResourcesAt((String)"samples/", null);
            for (URL sample : samples) {
                importer = new ModuleImporter(sample);
                importer.importModule((ICodeStore)codeStore);
            }
            dataStore.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

