/*
 * Decompiled with CFR 0.152.
 */
package prompto.codeserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import prompto.code.Dependency;
import prompto.code.ICodeStore;
import prompto.code.ImmutableCodeStore;
import prompto.code.Module;
import prompto.code.Version;
import prompto.code.WebSite;
import prompto.value.Image;

public class ModuleImporter {
    Module module;
    URL imageResource;
    URL codeResource;

    public ModuleImporter(String resourcePath) {
        this(Thread.currentThread().getContextClassLoader().getResource(resourcePath));
    }

    public ModuleImporter(URL url) {
        try {
            JsonNode descriptor = this.readDescriptor(url);
            Module module = this.createModule(descriptor);
            this.populateModule(module, descriptor);
            this.populateResources(url, descriptor);
            this.module = module;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void populateResources(URL url, JsonNode descriptor) throws MalformedURLException {
        if (descriptor.get("imageResource") != null) {
            this.imageResource = new URL(url, descriptor.get("imageResource").asText());
        }
        if (descriptor.get("codeResource") != null) {
            this.codeResource = new URL(url, descriptor.get("codeResource").asText());
        }
    }

    private void populateModule(Module module, JsonNode descriptor) {
        JsonNode dependencies;
        module.setName(this.readText(descriptor, "name"));
        module.setVersion(Version.parse((String)this.readText(descriptor, "version")));
        module.setDescription(this.readText(descriptor, "description"));
        if (module instanceof WebSite) {
            ((WebSite)module).setEntryPoint(this.readText(descriptor, "entryPoint"));
        }
        if ((dependencies = descriptor.get("dependencies")) != null) {
            module.setDependencies(this.populateDependencies(dependencies));
        }
    }

    private List<Dependency> populateDependencies(JsonNode descriptor) {
        ArrayList<Dependency> items = new ArrayList<Dependency>();
        for (JsonNode node : descriptor) {
            Dependency item = new Dependency();
            item.setName(this.readText(node, "name"));
            item.setVersion(this.readText(node, "version"));
            items.add(item);
        }
        return items;
    }

    private Module createModule(JsonNode descriptor) throws InstantiationException, IllegalAccessException {
        ICodeStore.ModuleType type = ICodeStore.ModuleType.valueOf((String)this.readText(descriptor, "type"));
        return (Module)type.getModuleClass().newInstance();
    }

    private JsonNode readDescriptor(URL path) throws JsonProcessingException, IOException {
        URL json = new URL(path, "module.json");
        try (InputStream input = json.openStream();){
            JsonNode jsonNode = new ObjectMapper().readTree(input);
            return jsonNode;
        }
    }

    private String readText(JsonNode descriptor, String fieldName) {
        JsonNode child = descriptor.get(fieldName);
        if (child == null) {
            return null;
        }
        return child.asText();
    }

    public void importModule(ICodeStore codeStore) throws Exception {
        Module existing = codeStore.fetchModule(this.module.getType(), this.module.getName(), this.module.getVersion());
        if (existing != null) {
            return;
        }
        if (this.imageResource != null) {
            this.module.setImage(Image.fromURL((URL)this.imageResource).getStorableData());
        }
        codeStore.storeModule(this.module);
        if (this.codeResource != null) {
            this.storeAssociatedCode(codeStore);
        }
    }

    private void storeAssociatedCode(ICodeStore codeStore) throws Exception {
        ImmutableCodeStore rcs = new ImmutableCodeStore(null, this.module.getType(), this.codeResource, this.module.getVersion());
        codeStore.storeDeclarations(rcs.getDeclarations(), rcs.getModuleDialect(), this.module.getVersion(), this.module.getDbId());
    }
}

