/*
 * Decompiled with CFR 0.152.
 */
package prompto.codeserver;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import prompto.server.AppServer;
import prompto.server.PromptoServlet;
import prompto.store.IDataStore;
import prompto.store.IStore;
import prompto.store.IStored;
import prompto.utils.Logger;
import prompto.value.IValue;

public class ModuleProcess {
    static Logger logger = new Logger();
    static Map<Object, ModuleProcess> modules = new HashMap<Object, ModuleProcess>();
    Object dbId;
    String module;
    String version;
    int port;
    Process process;
    private static final Pattern splitter;
    private static Set<String> relevantArgFullNames;
    private static List<String> relevantArgStartNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutDownAll() {
        logger.info(() -> "Shutting down module servers...");
        Map<Object, ModuleProcess> map = modules;
        synchronized (map) {
            ArrayList<ModuleProcess> values = new ArrayList<ModuleProcess>(modules.values());
            modules.clear();
            values.forEach(ModuleProcess::shutDown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long launchIfNeeded(Object dbId) {
        Map<Object, ModuleProcess> map = modules;
        synchronized (map) {
            try {
                ModuleProcess module;
                if (dbId instanceof IValue) {
                    dbId = ((IValue)dbId).getStorableData();
                }
                if ((module = modules.get(dbId)) != null && !module.process.isAlive()) {
                    module = null;
                }
                if (module == null) {
                    module = ModuleProcess.createModuleProcess(dbId);
                    modules.put(dbId, module);
                }
                return new Long(module.port);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }
    }

    private static ModuleProcess createModuleProcess(Object dbId) throws IOException, InterruptedException {
        IStored stored = ((IStore)IDataStore.instance.get()).fetchUnique(dbId);
        if (stored == null) {
            return null;
        }
        ModuleProcess module = new ModuleProcess();
        module.dbId = dbId;
        module.module = stored.getData("name").toString();
        module.version = stored.getData("version").toString();
        module.start();
        return module;
    }

    public void start() throws IOException, InterruptedException {
        this.port = this.findAvailablePort();
        String[] args = this.buildCommandLineArgs();
        ProcessBuilder builder = new ProcessBuilder(args).redirectError(ProcessBuilder.Redirect.INHERIT).directory(Files.createTempDirectory("prompto-" + this.module + "-", new FileAttribute[0]).toFile());
        this.process = OutStream.waitForServerReadiness(builder);
    }

    public void shutDown() {
        try {
            this.process.destroyForcibly();
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int findAvailablePort() throws IOException {
        try (ServerSocket s = new ServerSocket(0);){
            int n = s.getLocalPort();
            return n;
        }
    }

    private String[] buildCommandLineArgs() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("java");
        this.addClassPathArgs(cmds);
        cmds.add(AppServer.class.getName());
        this.addRelevantCmdLineArgs(cmds);
        this.addPromptoArgs(cmds);
        return cmds.toArray(new String[cmds.size()]);
    }

    private void addPromptoArgs(List<String> cmds) {
        cmds.add("-http_port");
        cmds.add(String.valueOf(this.port));
        cmds.add("-application");
        cmds.add(this.module.toString());
        cmds.add("-version");
        cmds.add(this.version.toString());
        String origin = (String)PromptoServlet.REGISTERED_ORIGIN.get();
        if (origin != null) {
            cmds.add("-origin");
            cmds.add(origin);
        }
    }

    private void addClassPathArgs(List<String> cmds) {
        String classPaths = Stream.of(System.getProperty("java.class.path").toString().split(":")).filter(s -> !s.contains("CodeServer")).collect(Collectors.joining(":"));
        cmds.add("-cp");
        cmds.add(classPaths);
    }

    private void addRelevantCmdLineArgs(List<String> cmds) {
        String cmdLine = System.getProperty("sun.java.command").toString();
        Matcher matcher = splitter.matcher(cmdLine);
        while (matcher.find()) {
            String key = matcher.group();
            if (!this.isRelevantCmdLineArg(key) || !matcher.find()) continue;
            cmds.add(key);
            cmds.add(matcher.group());
        }
    }

    private boolean isRelevantCmdLineArg(String key) {
        if (relevantArgFullNames.contains(key)) {
            return true;
        }
        return relevantArgStartNames.stream().anyMatch(key::startsWith);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(ModuleProcess::shutDownAll));
        splitter = Pattern.compile("[^\\s]*\"(\\\\+\"|[^\"])*?\"|[^\\s]*'(\\\\+'|[^'])*?'|(\\\\\\s|[^\\s])+", 8);
        relevantArgFullNames = new HashSet<String>(Arrays.asList("-codeStoreFactory", "-dataStoreFactory", "-addOns"));
        relevantArgStartNames = Arrays.asList("-mongo-", "-solr-");
    }

    static class OutStream {
        ProcessBuilder builder;
        Object ready = new Object();

        static Process waitForServerReadiness(ProcessBuilder builder) throws IOException, InterruptedException {
            OutStream out = new OutStream(builder);
            return out.waitForServerReadiness();
        }

        OutStream(ProcessBuilder builder) {
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Process waitForServerReadiness() throws InterruptedException, IOException {
            logger.info(() -> "Starting: " + this.builder.command().toString());
            Process process = this.builder.start();
            InputStream input = process.getInputStream();
            Thread reader = new Thread(() -> {
                byte[] data = new byte[65536];
                while (process.isAlive()) {
                    try {
                        int read = input.read(data);
                        if (read >= 0) {
                            if (read <= 0) continue;
                            System.out.write(data, 0, read);
                            if (!new String(data, 0, read).contains("Web server successfully started on port ")) continue;
                            Object object = this.ready;
                            synchronized (object) {
                                this.ready.notify();
                                continue;
                            }
                        }
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
            });
            reader.start();
            Object object = this.ready;
            synchronized (object) {
                this.ready.wait();
            }
            return process;
        }
    }
}

