/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.accesstoken;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.accesstoken.AccessTokens;
import org.proshin.finapi.accesstoken.ClientAccessToken;
import org.proshin.finapi.accesstoken.UserAccessToken;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.pair.UrlEncodedPair;

public final class FpAccessTokens
implements AccessTokens {
    private final Endpoint endpoint;
    private final String tokenUrl;
    private final String revokeUrl;

    public FpAccessTokens(Endpoint endpoint) {
        this(endpoint, "/oauth/token", "/oauth/revoke");
    }

    public FpAccessTokens(Endpoint endpoint, String tokenUrl, String revokeUrl) {
        this.endpoint = endpoint;
        this.tokenUrl = tokenUrl;
        this.revokeUrl = revokeUrl;
    }

    @Override
    public AccessToken clientToken(String clientId, String clientSecret) {
        UrlEncodedFormEntity entity;
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("grant_type", "client_credentials"));
        parameters.add(new BasicNameValuePair("client_id", clientId));
        parameters.add(new BasicNameValuePair("client_secret", clientSecret));
        try {
            entity = new UrlEncodedFormEntity(parameters);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Couldn't instantiate an entity for POST request", exception);
        }
        return new ClientAccessToken(new JSONObject(this.endpoint.post(this.tokenUrl, (HttpEntity)entity, 200)));
    }

    @Override
    public AccessToken userToken(String clientId, String clientSecret, String username, String password) {
        UrlEncodedFormEntity entity;
        ArrayList<UrlEncodedPair> parameters = new ArrayList<UrlEncodedPair>();
        parameters.add(new UrlEncodedPair("grant_type", "password"));
        parameters.add(new UrlEncodedPair("client_id", clientId));
        parameters.add(new UrlEncodedPair("client_secret", clientSecret));
        parameters.add(new UrlEncodedPair("username", username));
        parameters.add(new UrlEncodedPair("password", password));
        try {
            entity = new UrlEncodedFormEntity(parameters);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Couldn't instantiate an entity for POST request", exception);
        }
        return new UserAccessToken(new JSONObject(this.endpoint.post(this.tokenUrl, (HttpEntity)entity, 200)));
    }

    @Override
    public AccessToken userToken(String clientId, String clientSecret, String refreshToken) {
        UrlEncodedFormEntity entity;
        ArrayList<UrlEncodedPair> parameters = new ArrayList<UrlEncodedPair>();
        parameters.add(new UrlEncodedPair("grant_type", "refresh_token"));
        parameters.add(new UrlEncodedPair("client_id", clientId));
        parameters.add(new UrlEncodedPair("client_secret", clientSecret));
        parameters.add(new UrlEncodedPair("refresh_token", refreshToken));
        try {
            entity = new UrlEncodedFormEntity(parameters);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Couldn't instantiate an entity for POST request", exception);
        }
        return new UserAccessToken(new JSONObject(this.endpoint.post(this.tokenUrl, (HttpEntity)entity, 200)));
    }

    @Override
    public void revoke(AccessToken clientToken, AccessToken userToken, AccessTokens.RevokeToken tokensToRevoke) {
        UrlEncodedFormEntity entity;
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("token", userToken.accessToken()));
        switch (tokensToRevoke) {
            case ACCESS_TOKEN_ONLY: {
                parameters.add(new BasicNameValuePair("token_type_hint", "access_token"));
                break;
            }
            case REFRESH_TOKEN_ONLY: {
                parameters.add(new BasicNameValuePair("token_type_hint", "refresh_token"));
                break;
            }
        }
        try {
            entity = new UrlEncodedFormEntity(parameters);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("Couldn't instantiate an entity for POST request", exception);
        }
        this.endpoint.post(this.revokeUrl, clientToken, (HttpEntity)entity, 200);
    }
}

