/*
 * Decompiled with CFR 0.152.
 */
package org.proshin.finapi.account;

import org.apache.http.NameValuePair;
import org.json.JSONObject;
import org.proshin.finapi.accesstoken.AccessToken;
import org.proshin.finapi.account.Account;
import org.proshin.finapi.account.Accounts;
import org.proshin.finapi.account.FpAccount;
import org.proshin.finapi.account.FpMoneyTransfer;
import org.proshin.finapi.account.MoneyTransfer;
import org.proshin.finapi.account.in.DailyBalancesCriteria;
import org.proshin.finapi.account.in.FpQueryCriteria;
import org.proshin.finapi.account.out.DailyBalances;
import org.proshin.finapi.account.out.DirectDebit;
import org.proshin.finapi.account.out.FpDailyBalances;
import org.proshin.finapi.account.out.FpDirectDebit;
import org.proshin.finapi.endpoint.Endpoint;
import org.proshin.finapi.primitives.IterableJsonArray;

public final class FpAccounts
implements Accounts {
    private final Endpoint endpoint;
    private final AccessToken token;
    private final String url;

    public FpAccounts(Endpoint endpoint, AccessToken token) {
        this(endpoint, token, "/api/v1/accounts/");
    }

    public FpAccounts(Endpoint endpoint, AccessToken token, String url) {
        this.endpoint = endpoint;
        this.token = token;
        this.url = url;
    }

    @Override
    public Account one(Long id) {
        return new FpAccount(this.endpoint, this.token, new JSONObject(this.endpoint.get(this.url + id, this.token, new NameValuePair[0])), this.url);
    }

    @Override
    public Iterable<Account> query(FpQueryCriteria criteria) {
        return new IterableJsonArray<Account>(new JSONObject(this.endpoint.get(this.url, this.token, criteria)).getJSONArray("accounts"), (array, index) -> new FpAccount(this.endpoint, this.token, array.getJSONObject(index.intValue()), this.url));
    }

    @Override
    public DailyBalances dailyBalances(DailyBalancesCriteria criteria) {
        return new FpDailyBalances(new JSONObject(this.endpoint.get(this.url + "dailyBalances", this.token, criteria)));
    }

    @Override
    public MoneyTransfer moneyTransfer() {
        return new FpMoneyTransfer(this.endpoint, this.token, this.url);
    }

    @Override
    public DirectDebit directDebit() {
        return new FpDirectDebit(this.endpoint, this.token, this.url);
    }

    @Override
    public void deleteAll() {
        this.endpoint.delete(this.url, this.token, new NameValuePair[0]);
    }
}

